package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class AssociateResolverEndpointIpAddressRequest(
    resolverEndpointId: ResourceId,
    ipAddress: zio.aws.route53resolver.model.IpAddressUpdate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.AssociateResolverEndpointIpAddressRequest = {
    import AssociateResolverEndpointIpAddressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.AssociateResolverEndpointIpAddressRequest
      .builder()
      .resolverEndpointId(
        ResourceId.unwrap(resolverEndpointId): java.lang.String
      )
      .ipAddress(ipAddress.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.AssociateResolverEndpointIpAddressRequest.ReadOnly =
    zio.aws.route53resolver.model.AssociateResolverEndpointIpAddressRequest
      .wrap(buildAwsValue())
}
object AssociateResolverEndpointIpAddressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.AssociateResolverEndpointIpAddressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.AssociateResolverEndpointIpAddressRequest =
      zio.aws.route53resolver.model.AssociateResolverEndpointIpAddressRequest(
        resolverEndpointId,
        ipAddress.asEditable
      )
    def resolverEndpointId: ResourceId
    def ipAddress: zio.aws.route53resolver.model.IpAddressUpdate.ReadOnly
    def getResolverEndpointId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(resolverEndpointId)
    def getIpAddress: ZIO[
      Any,
      Nothing,
      zio.aws.route53resolver.model.IpAddressUpdate.ReadOnly
    ] = ZIO.succeed(ipAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.AssociateResolverEndpointIpAddressRequest
  ) extends zio.aws.route53resolver.model.AssociateResolverEndpointIpAddressRequest.ReadOnly {
    override val resolverEndpointId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.resolverEndpointId())
    override val ipAddress
        : zio.aws.route53resolver.model.IpAddressUpdate.ReadOnly =
      zio.aws.route53resolver.model.IpAddressUpdate.wrap(impl.ipAddress())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.AssociateResolverEndpointIpAddressRequest
  ): zio.aws.route53resolver.model.AssociateResolverEndpointIpAddressRequest.ReadOnly =
    new Wrapper(impl)
}
