package zio.aws.route53resolver.model
import scala.jdk.CollectionConverters._
sealed trait Validation {
  def unwrap: software.amazon.awssdk.services.route53resolver.model.Validation
}
object Validation {
  def wrap(
      value: software.amazon.awssdk.services.route53resolver.model.Validation
  ): zio.aws.route53resolver.model.Validation = value match {
    case software.amazon.awssdk.services.route53resolver.model.Validation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53resolver.model.Validation.ENABLE =>
      val r = ENABLE
      r
    case software.amazon.awssdk.services.route53resolver.model.Validation.DISABLE =>
      val r = DISABLE
      r
    case software.amazon.awssdk.services.route53resolver.model.Validation.USE_LOCAL_RESOURCE_SETTING =>
      val r = USE_LOCAL_RESOURCE_SETTING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53resolver.model.Validation {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.Validation =
      software.amazon.awssdk.services.route53resolver.model.Validation.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLE extends zio.aws.route53resolver.model.Validation {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.Validation =
      software.amazon.awssdk.services.route53resolver.model.Validation.ENABLE
  }
  case object DISABLE extends zio.aws.route53resolver.model.Validation {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.Validation =
      software.amazon.awssdk.services.route53resolver.model.Validation.DISABLE
  }
  case object USE_LOCAL_RESOURCE_SETTING
      extends zio.aws.route53resolver.model.Validation {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.Validation =
      software.amazon.awssdk.services.route53resolver.model.Validation.USE_LOCAL_RESOURCE_SETTING
  }
}
