package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.{
  ResolverQueryLogConfigPolicy,
  Arn
}
import scala.jdk.CollectionConverters._
final case class PutResolverQueryLogConfigPolicyRequest(
    arn: Arn,
    resolverQueryLogConfigPolicy: ResolverQueryLogConfigPolicy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.PutResolverQueryLogConfigPolicyRequest = {
    import PutResolverQueryLogConfigPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.PutResolverQueryLogConfigPolicyRequest
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .resolverQueryLogConfigPolicy(
        ResolverQueryLogConfigPolicy.unwrap(
          resolverQueryLogConfigPolicy
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.PutResolverQueryLogConfigPolicyRequest.ReadOnly =
    zio.aws.route53resolver.model.PutResolverQueryLogConfigPolicyRequest
      .wrap(buildAwsValue())
}
object PutResolverQueryLogConfigPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.PutResolverQueryLogConfigPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.PutResolverQueryLogConfigPolicyRequest =
      zio.aws.route53resolver.model.PutResolverQueryLogConfigPolicyRequest(
        arn,
        resolverQueryLogConfigPolicy
      )
    def arn: Arn
    def resolverQueryLogConfigPolicy: ResolverQueryLogConfigPolicy
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getResolverQueryLogConfigPolicy
        : ZIO[Any, Nothing, ResolverQueryLogConfigPolicy] =
      ZIO.succeed(resolverQueryLogConfigPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.PutResolverQueryLogConfigPolicyRequest
  ) extends zio.aws.route53resolver.model.PutResolverQueryLogConfigPolicyRequest.ReadOnly {
    override val arn: Arn =
      zio.aws.route53resolver.model.primitives.Arn(impl.arn())
    override val resolverQueryLogConfigPolicy: ResolverQueryLogConfigPolicy =
      zio.aws.route53resolver.model.primitives
        .ResolverQueryLogConfigPolicy(impl.resolverQueryLogConfigPolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.PutResolverQueryLogConfigPolicyRequest
  ): zio.aws.route53resolver.model.PutResolverQueryLogConfigPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
