package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{Ipv6, Port, Ip}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class TargetAddress(
    ip: Optional[Ip] = Optional.Absent,
    port: Optional[Port] = Optional.Absent,
    ipv6: Optional[Ipv6] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.TargetAddress = {
    import TargetAddress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.TargetAddress
      .builder()
      .optionallyWith(ip.map(value => Ip.unwrap(value): java.lang.String))(_.ip)
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .optionallyWith(ipv6.map(value => Ipv6.unwrap(value): java.lang.String))(
        _.ipv6
      )
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.TargetAddress.ReadOnly =
    zio.aws.route53resolver.model.TargetAddress.wrap(buildAwsValue())
}
object TargetAddress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.TargetAddress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.TargetAddress =
      zio.aws.route53resolver.model.TargetAddress(
        ip.map(value => value),
        port.map(value => value),
        ipv6.map(value => value)
      )
    def ip: Optional[Ip]
    def port: Optional[Port]
    def ipv6: Optional[Ipv6]
    def getIp: ZIO[Any, AwsError, Ip] = AwsError.unwrapOptionField("ip", ip)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
    def getIpv6: ZIO[Any, AwsError, Ipv6] =
      AwsError.unwrapOptionField("ipv6", ipv6)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.TargetAddress
  ) extends zio.aws.route53resolver.model.TargetAddress.ReadOnly {
    override val ip: Optional[Ip] = zio.aws.core.internal
      .optionalFromNullable(impl.ip())
      .map(value => zio.aws.route53resolver.model.primitives.Ip(value))
    override val port: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.route53resolver.model.primitives.Port(value))
    override val ipv6: Optional[Ipv6] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6())
      .map(value => zio.aws.route53resolver.model.primitives.Ipv6(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.TargetAddress
  ): zio.aws.route53resolver.model.TargetAddress.ReadOnly = new Wrapper(impl)
}
