package zio.aws.route53resolver.model
import scala.jdk.CollectionConverters._
sealed trait ResolverEndpointType {
  def unwrap: software.amazon.awssdk.services.route53resolver.model.ResolverEndpointType
}
object ResolverEndpointType {
  def wrap(
      value: software.amazon.awssdk.services.route53resolver.model.ResolverEndpointType
  ): zio.aws.route53resolver.model.ResolverEndpointType = value match {
    case software.amazon.awssdk.services.route53resolver.model.ResolverEndpointType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53resolver.model.ResolverEndpointType.IPV6 =>
      val r = IPV6
      r
    case software.amazon.awssdk.services.route53resolver.model.ResolverEndpointType.IPV4 =>
      val r = IPV4
      r
    case software.amazon.awssdk.services.route53resolver.model.ResolverEndpointType.DUALSTACK =>
      val r = DUALSTACK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53resolver.model.ResolverEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.ResolverEndpointType =
      software.amazon.awssdk.services.route53resolver.model.ResolverEndpointType.UNKNOWN_TO_SDK_VERSION
  }
  case object IPV6 extends zio.aws.route53resolver.model.ResolverEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.ResolverEndpointType =
      software.amazon.awssdk.services.route53resolver.model.ResolverEndpointType.IPV6
  }
  case object IPV4 extends zio.aws.route53resolver.model.ResolverEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.ResolverEndpointType =
      software.amazon.awssdk.services.route53resolver.model.ResolverEndpointType.IPV4
  }
  case object DUALSTACK
      extends zio.aws.route53resolver.model.ResolverEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.ResolverEndpointType =
      software.amazon.awssdk.services.route53resolver.model.ResolverEndpointType.DUALSTACK
  }
}
