package zio.aws.route53resolver.model
import scala.jdk.CollectionConverters._
sealed trait FirewallFailOpenStatus {
  def unwrap: software.amazon.awssdk.services.route53resolver.model.FirewallFailOpenStatus
}
object FirewallFailOpenStatus {
  def wrap(
      value: software.amazon.awssdk.services.route53resolver.model.FirewallFailOpenStatus
  ): zio.aws.route53resolver.model.FirewallFailOpenStatus = value match {
    case software.amazon.awssdk.services.route53resolver.model.FirewallFailOpenStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53resolver.model.FirewallFailOpenStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.route53resolver.model.FirewallFailOpenStatus.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.route53resolver.model.FirewallFailOpenStatus.USE_LOCAL_RESOURCE_SETTING =>
      val r = USE_LOCAL_RESOURCE_SETTING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53resolver.model.FirewallFailOpenStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.FirewallFailOpenStatus =
      software.amazon.awssdk.services.route53resolver.model.FirewallFailOpenStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED
      extends zio.aws.route53resolver.model.FirewallFailOpenStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.FirewallFailOpenStatus =
      software.amazon.awssdk.services.route53resolver.model.FirewallFailOpenStatus.ENABLED
  }
  case object DISABLED
      extends zio.aws.route53resolver.model.FirewallFailOpenStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.FirewallFailOpenStatus =
      software.amazon.awssdk.services.route53resolver.model.FirewallFailOpenStatus.DISABLED
  }
  case object USE_LOCAL_RESOURCE_SETTING
      extends zio.aws.route53resolver.model.FirewallFailOpenStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.FirewallFailOpenStatus =
      software.amazon.awssdk.services.route53resolver.model.FirewallFailOpenStatus.USE_LOCAL_RESOURCE_SETTING
  }
}
