package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class GetResolverQueryLogConfigPolicyRequest(arn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigPolicyRequest = {
    import GetResolverQueryLogConfigPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigPolicyRequest
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetResolverQueryLogConfigPolicyRequest.ReadOnly =
    zio.aws.route53resolver.model.GetResolverQueryLogConfigPolicyRequest
      .wrap(buildAwsValue())
}
object GetResolverQueryLogConfigPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.GetResolverQueryLogConfigPolicyRequest =
      zio.aws.route53resolver.model.GetResolverQueryLogConfigPolicyRequest(arn)
    def arn: Arn
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigPolicyRequest
  ) extends zio.aws.route53resolver.model.GetResolverQueryLogConfigPolicyRequest.ReadOnly {
    override val arn: Arn =
      zio.aws.route53resolver.model.primitives.Arn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigPolicyRequest
  ): zio.aws.route53resolver.model.GetResolverQueryLogConfigPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
