package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{
  BlockOverrideTtl,
  BlockOverrideDomain,
  CreatorRequestId,
  Priority,
  Name,
  ResourceId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateFirewallRuleRequest(
    creatorRequestId: CreatorRequestId,
    firewallRuleGroupId: ResourceId,
    firewallDomainListId: ResourceId,
    priority: Priority,
    action: zio.aws.route53resolver.model.Action,
    blockResponse: Optional[zio.aws.route53resolver.model.BlockResponse] =
      Optional.Absent,
    blockOverrideDomain: Optional[BlockOverrideDomain] = Optional.Absent,
    blockOverrideDnsType: Optional[
      zio.aws.route53resolver.model.BlockOverrideDnsType
    ] = Optional.Absent,
    blockOverrideTtl: Optional[BlockOverrideTtl] = Optional.Absent,
    name: Name
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.CreateFirewallRuleRequest = {
    import CreateFirewallRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.CreateFirewallRuleRequest
      .builder()
      .creatorRequestId(
        CreatorRequestId.unwrap(creatorRequestId): java.lang.String
      )
      .firewallRuleGroupId(
        ResourceId.unwrap(firewallRuleGroupId): java.lang.String
      )
      .firewallDomainListId(
        ResourceId.unwrap(firewallDomainListId): java.lang.String
      )
      .priority(Priority.unwrap(priority): Integer)
      .action(action.unwrap)
      .optionallyWith(blockResponse.map(value => value.unwrap))(_.blockResponse)
      .optionallyWith(
        blockOverrideDomain.map(value =>
          BlockOverrideDomain.unwrap(value): java.lang.String
        )
      )(_.blockOverrideDomain)
      .optionallyWith(blockOverrideDnsType.map(value => value.unwrap))(
        _.blockOverrideDnsType
      )
      .optionallyWith(
        blockOverrideTtl.map(value => BlockOverrideTtl.unwrap(value): Integer)
      )(_.blockOverrideTtl)
      .name(Name.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.CreateFirewallRuleRequest.ReadOnly =
    zio.aws.route53resolver.model.CreateFirewallRuleRequest
      .wrap(buildAwsValue())
}
object CreateFirewallRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.CreateFirewallRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.CreateFirewallRuleRequest =
      zio.aws.route53resolver.model.CreateFirewallRuleRequest(
        creatorRequestId,
        firewallRuleGroupId,
        firewallDomainListId,
        priority,
        action,
        blockResponse.map(value => value),
        blockOverrideDomain.map(value => value),
        blockOverrideDnsType.map(value => value),
        blockOverrideTtl.map(value => value),
        name
      )
    def creatorRequestId: CreatorRequestId
    def firewallRuleGroupId: ResourceId
    def firewallDomainListId: ResourceId
    def priority: Priority
    def action: zio.aws.route53resolver.model.Action
    def blockResponse: Optional[zio.aws.route53resolver.model.BlockResponse]
    def blockOverrideDomain: Optional[BlockOverrideDomain]
    def blockOverrideDnsType
        : Optional[zio.aws.route53resolver.model.BlockOverrideDnsType]
    def blockOverrideTtl: Optional[BlockOverrideTtl]
    def name: Name
    def getCreatorRequestId: ZIO[Any, Nothing, CreatorRequestId] =
      ZIO.succeed(creatorRequestId)
    def getFirewallRuleGroupId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallRuleGroupId)
    def getFirewallDomainListId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallDomainListId)
    def getPriority: ZIO[Any, Nothing, Priority] = ZIO.succeed(priority)
    def getAction: ZIO[Any, Nothing, zio.aws.route53resolver.model.Action] =
      ZIO.succeed(action)
    def getBlockResponse
        : ZIO[Any, AwsError, zio.aws.route53resolver.model.BlockResponse] =
      AwsError.unwrapOptionField("blockResponse", blockResponse)
    def getBlockOverrideDomain: ZIO[Any, AwsError, BlockOverrideDomain] =
      AwsError.unwrapOptionField("blockOverrideDomain", blockOverrideDomain)
    def getBlockOverrideDnsType: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.BlockOverrideDnsType
    ] = AwsError.unwrapOptionField("blockOverrideDnsType", blockOverrideDnsType)
    def getBlockOverrideTtl: ZIO[Any, AwsError, BlockOverrideTtl] =
      AwsError.unwrapOptionField("blockOverrideTtl", blockOverrideTtl)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateFirewallRuleRequest
  ) extends zio.aws.route53resolver.model.CreateFirewallRuleRequest.ReadOnly {
    override val creatorRequestId: CreatorRequestId =
      zio.aws.route53resolver.model.primitives
        .CreatorRequestId(impl.creatorRequestId())
    override val firewallRuleGroupId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.firewallRuleGroupId())
    override val firewallDomainListId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.firewallDomainListId())
    override val priority: Priority =
      zio.aws.route53resolver.model.primitives.Priority(impl.priority())
    override val action: zio.aws.route53resolver.model.Action =
      zio.aws.route53resolver.model.Action.wrap(impl.action())
    override val blockResponse
        : Optional[zio.aws.route53resolver.model.BlockResponse] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockResponse())
        .map(value => zio.aws.route53resolver.model.BlockResponse.wrap(value))
    override val blockOverrideDomain: Optional[BlockOverrideDomain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockOverrideDomain())
        .map(value =>
          zio.aws.route53resolver.model.primitives.BlockOverrideDomain(value)
        )
    override val blockOverrideDnsType
        : Optional[zio.aws.route53resolver.model.BlockOverrideDnsType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockOverrideDnsType())
        .map(value =>
          zio.aws.route53resolver.model.BlockOverrideDnsType.wrap(value)
        )
    override val blockOverrideTtl: Optional[BlockOverrideTtl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockOverrideTtl())
        .map(value =>
          zio.aws.route53resolver.model.primitives.BlockOverrideTtl(value)
        )
    override val name: Name =
      zio.aws.route53resolver.model.primitives.Name(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateFirewallRuleRequest
  ): zio.aws.route53resolver.model.CreateFirewallRuleRequest.ReadOnly =
    new Wrapper(impl)
}
