package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{Ipv6, Ip, SubnetId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IpAddressRequest(
    subnetId: SubnetId,
    ip: Optional[Ip] = Optional.Absent,
    ipv6: Optional[Ipv6] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.IpAddressRequest = {
    import IpAddressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.IpAddressRequest
      .builder()
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .optionallyWith(ip.map(value => Ip.unwrap(value): java.lang.String))(_.ip)
      .optionallyWith(ipv6.map(value => Ipv6.unwrap(value): java.lang.String))(
        _.ipv6
      )
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.IpAddressRequest.ReadOnly =
    zio.aws.route53resolver.model.IpAddressRequest.wrap(buildAwsValue())
}
object IpAddressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.IpAddressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.IpAddressRequest =
      zio.aws.route53resolver.model.IpAddressRequest(
        subnetId,
        ip.map(value => value),
        ipv6.map(value => value)
      )
    def subnetId: SubnetId
    def ip: Optional[Ip]
    def ipv6: Optional[Ipv6]
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
    def getIp: ZIO[Any, AwsError, Ip] = AwsError.unwrapOptionField("ip", ip)
    def getIpv6: ZIO[Any, AwsError, Ipv6] =
      AwsError.unwrapOptionField("ipv6", ipv6)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.IpAddressRequest
  ) extends zio.aws.route53resolver.model.IpAddressRequest.ReadOnly {
    override val subnetId: SubnetId =
      zio.aws.route53resolver.model.primitives.SubnetId(impl.subnetId())
    override val ip: Optional[Ip] = zio.aws.core.internal
      .optionalFromNullable(impl.ip())
      .map(value => zio.aws.route53resolver.model.primitives.Ip(value))
    override val ipv6: Optional[Ipv6] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6())
      .map(value => zio.aws.route53resolver.model.primitives.Ipv6(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.IpAddressRequest
  ): zio.aws.route53resolver.model.IpAddressRequest.ReadOnly = new Wrapper(impl)
}
