package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  SubnetId,
  Ip,
  Rfc3339TimeString,
  Ipv6,
  ResourceId,
  StatusMessage
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IpAddressResponse(
    ipId: Optional[ResourceId] = Optional.Absent,
    subnetId: Optional[SubnetId] = Optional.Absent,
    ip: Optional[Ip] = Optional.Absent,
    ipv6: Optional[Ipv6] = Optional.Absent,
    status: Optional[zio.aws.route53resolver.model.IpAddressStatus] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    creationTime: Optional[Rfc3339TimeString] = Optional.Absent,
    modificationTime: Optional[Rfc3339TimeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.IpAddressResponse = {
    import IpAddressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.IpAddressResponse
      .builder()
      .optionallyWith(
        ipId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.ipId)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(ip.map(value => Ip.unwrap(value): java.lang.String))(_.ip)
      .optionallyWith(ipv6.map(value => Ipv6.unwrap(value): java.lang.String))(
        _.ipv6
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        creationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.creationTime)
      .optionallyWith(
        modificationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.modificationTime)
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.IpAddressResponse.ReadOnly =
    zio.aws.route53resolver.model.IpAddressResponse.wrap(buildAwsValue())
}
object IpAddressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.IpAddressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.IpAddressResponse =
      zio.aws.route53resolver.model.IpAddressResponse(
        ipId.map(value => value),
        subnetId.map(value => value),
        ip.map(value => value),
        ipv6.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        creationTime.map(value => value),
        modificationTime.map(value => value)
      )
    def ipId: Optional[ResourceId]
    def subnetId: Optional[SubnetId]
    def ip: Optional[Ip]
    def ipv6: Optional[Ipv6]
    def status: Optional[zio.aws.route53resolver.model.IpAddressStatus]
    def statusMessage: Optional[StatusMessage]
    def creationTime: Optional[Rfc3339TimeString]
    def modificationTime: Optional[Rfc3339TimeString]
    def getIpId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("ipId", ipId)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getIp: ZIO[Any, AwsError, Ip] = AwsError.unwrapOptionField("ip", ip)
    def getIpv6: ZIO[Any, AwsError, Ipv6] =
      AwsError.unwrapOptionField("ipv6", ipv6)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.route53resolver.model.IpAddressStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getModificationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("modificationTime", modificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.IpAddressResponse
  ) extends zio.aws.route53resolver.model.IpAddressResponse.ReadOnly {
    override val ipId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.ipId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val subnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.route53resolver.model.primitives.SubnetId(value))
    override val ip: Optional[Ip] = zio.aws.core.internal
      .optionalFromNullable(impl.ip())
      .map(value => zio.aws.route53resolver.model.primitives.Ip(value))
    override val ipv6: Optional[Ipv6] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6())
      .map(value => zio.aws.route53resolver.model.primitives.Ipv6(value))
    override val status
        : Optional[zio.aws.route53resolver.model.IpAddressStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.route53resolver.model.IpAddressStatus.wrap(value))
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value =>
        zio.aws.route53resolver.model.primitives.StatusMessage(value)
      )
    override val creationTime: Optional[Rfc3339TimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value =>
          zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
        )
    override val modificationTime: Optional[Rfc3339TimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modificationTime())
        .map(value =>
          zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.IpAddressResponse
  ): zio.aws.route53resolver.model.IpAddressResponse.ReadOnly = new Wrapper(
    impl
  )
}
