package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class GetResolverEndpointRequest(resolverEndpointId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetResolverEndpointRequest = {
    import GetResolverEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetResolverEndpointRequest
      .builder()
      .resolverEndpointId(
        ResourceId.unwrap(resolverEndpointId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetResolverEndpointRequest.ReadOnly =
    zio.aws.route53resolver.model.GetResolverEndpointRequest
      .wrap(buildAwsValue())
}
object GetResolverEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetResolverEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.GetResolverEndpointRequest =
      zio.aws.route53resolver.model
        .GetResolverEndpointRequest(resolverEndpointId)
    def resolverEndpointId: ResourceId
    def getResolverEndpointId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(resolverEndpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverEndpointRequest
  ) extends zio.aws.route53resolver.model.GetResolverEndpointRequest.ReadOnly {
    override val resolverEndpointId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.resolverEndpointId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverEndpointRequest
  ): zio.aws.route53resolver.model.GetResolverEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
