package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  CreatorRequestId,
  DestinationArn,
  ResolverQueryLogConfigName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateResolverQueryLogConfigRequest(
    name: ResolverQueryLogConfigName,
    destinationArn: DestinationArn,
    creatorRequestId: CreatorRequestId,
    tags: Optional[Iterable[zio.aws.route53resolver.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.CreateResolverQueryLogConfigRequest = {
    import CreateResolverQueryLogConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.CreateResolverQueryLogConfigRequest
      .builder()
      .name(ResolverQueryLogConfigName.unwrap(name): java.lang.String)
      .destinationArn(DestinationArn.unwrap(destinationArn): java.lang.String)
      .creatorRequestId(
        CreatorRequestId.unwrap(creatorRequestId): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.CreateResolverQueryLogConfigRequest.ReadOnly =
    zio.aws.route53resolver.model.CreateResolverQueryLogConfigRequest
      .wrap(buildAwsValue())
}
object CreateResolverQueryLogConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.CreateResolverQueryLogConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.CreateResolverQueryLogConfigRequest =
      zio.aws.route53resolver.model.CreateResolverQueryLogConfigRequest(
        name,
        destinationArn,
        creatorRequestId,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: ResolverQueryLogConfigName
    def destinationArn: DestinationArn
    def creatorRequestId: CreatorRequestId
    def tags: Optional[List[zio.aws.route53resolver.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, ResolverQueryLogConfigName] =
      ZIO.succeed(name)
    def getDestinationArn: ZIO[Any, Nothing, DestinationArn] =
      ZIO.succeed(destinationArn)
    def getCreatorRequestId: ZIO[Any, Nothing, CreatorRequestId] =
      ZIO.succeed(creatorRequestId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.route53resolver.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateResolverQueryLogConfigRequest
  ) extends zio.aws.route53resolver.model.CreateResolverQueryLogConfigRequest.ReadOnly {
    override val name: ResolverQueryLogConfigName =
      zio.aws.route53resolver.model.primitives
        .ResolverQueryLogConfigName(impl.name())
    override val destinationArn: DestinationArn =
      zio.aws.route53resolver.model.primitives
        .DestinationArn(impl.destinationArn())
    override val creatorRequestId: CreatorRequestId =
      zio.aws.route53resolver.model.primitives
        .CreatorRequestId(impl.creatorRequestId())
    override val tags
        : Optional[List[zio.aws.route53resolver.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53resolver.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateResolverQueryLogConfigRequest
  ): zio.aws.route53resolver.model.CreateResolverQueryLogConfigRequest.ReadOnly =
    new Wrapper(impl)
}
