package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListOutpostResolversResponse(
    outpostResolvers: Optional[
      Iterable[zio.aws.route53resolver.model.OutpostResolver]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversResponse = {
    import ListOutpostResolversResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversResponse
      .builder()
      .optionallyWith(
        outpostResolvers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outpostResolvers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListOutpostResolversResponse.ReadOnly =
    zio.aws.route53resolver.model.ListOutpostResolversResponse
      .wrap(buildAwsValue())
}
object ListOutpostResolversResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ListOutpostResolversResponse =
      zio.aws.route53resolver.model.ListOutpostResolversResponse(
        outpostResolvers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def outpostResolvers
        : Optional[List[zio.aws.route53resolver.model.OutpostResolver.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getOutpostResolvers: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.OutpostResolver.ReadOnly
    ]] = AwsError.unwrapOptionField("outpostResolvers", outpostResolvers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversResponse
  ) extends zio.aws.route53resolver.model.ListOutpostResolversResponse.ReadOnly {
    override val outpostResolvers: Optional[
      List[zio.aws.route53resolver.model.OutpostResolver.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostResolvers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.OutpostResolver.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversResponse
  ): zio.aws.route53resolver.model.ListOutpostResolversResponse.ReadOnly =
    new Wrapper(impl)
}
