package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateFirewallRuleGroupAssociationResponse(
    firewallRuleGroupAssociation: Optional[
      zio.aws.route53resolver.model.FirewallRuleGroupAssociation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse = {
    import UpdateFirewallRuleGroupAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse
      .builder()
      .optionallyWith(
        firewallRuleGroupAssociation.map(value => value.buildAwsValue())
      )(_.firewallRuleGroupAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse.ReadOnly =
    zio.aws.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse
      .wrap(buildAwsValue())
}
object UpdateFirewallRuleGroupAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse =
      zio.aws.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse(
        firewallRuleGroupAssociation.map(value => value.asEditable)
      )
    def firewallRuleGroupAssociation: Optional[
      zio.aws.route53resolver.model.FirewallRuleGroupAssociation.ReadOnly
    ]
    def getFirewallRuleGroupAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallRuleGroupAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "firewallRuleGroupAssociation",
      firewallRuleGroupAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse
  ) extends zio.aws.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse.ReadOnly {
    override val firewallRuleGroupAssociation: Optional[
      zio.aws.route53resolver.model.FirewallRuleGroupAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallRuleGroupAssociation())
      .map(value =>
        zio.aws.route53resolver.model.FirewallRuleGroupAssociation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse
  ): zio.aws.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
