package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteOutpostResolverResponse(
    outpostResolver: Optional[zio.aws.route53resolver.model.OutpostResolver] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.DeleteOutpostResolverResponse = {
    import DeleteOutpostResolverResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.DeleteOutpostResolverResponse
      .builder()
      .optionallyWith(outpostResolver.map(value => value.buildAwsValue()))(
        _.outpostResolver
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.DeleteOutpostResolverResponse.ReadOnly =
    zio.aws.route53resolver.model.DeleteOutpostResolverResponse
      .wrap(buildAwsValue())
}
object DeleteOutpostResolverResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.DeleteOutpostResolverResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.DeleteOutpostResolverResponse =
      zio.aws.route53resolver.model.DeleteOutpostResolverResponse(
        outpostResolver.map(value => value.asEditable)
      )
    def outpostResolver
        : Optional[zio.aws.route53resolver.model.OutpostResolver.ReadOnly]
    def getOutpostResolver: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.OutpostResolver.ReadOnly
    ] = AwsError.unwrapOptionField("outpostResolver", outpostResolver)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteOutpostResolverResponse
  ) extends zio.aws.route53resolver.model.DeleteOutpostResolverResponse.ReadOnly {
    override val outpostResolver
        : Optional[zio.aws.route53resolver.model.OutpostResolver.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outpostResolver())
        .map(value => zio.aws.route53resolver.model.OutpostResolver.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteOutpostResolverResponse
  ): zio.aws.route53resolver.model.DeleteOutpostResolverResponse.ReadOnly =
    new Wrapper(impl)
}
