package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class UpdateFirewallConfigRequest(
    resourceId: ResourceId,
    firewallFailOpen: zio.aws.route53resolver.model.FirewallFailOpenStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateFirewallConfigRequest = {
    import UpdateFirewallConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateFirewallConfigRequest
      .builder()
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .firewallFailOpen(firewallFailOpen.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateFirewallConfigRequest.ReadOnly =
    zio.aws.route53resolver.model.UpdateFirewallConfigRequest
      .wrap(buildAwsValue())
}
object UpdateFirewallConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateFirewallConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.UpdateFirewallConfigRequest =
      zio.aws.route53resolver.model
        .UpdateFirewallConfigRequest(resourceId, firewallFailOpen)
    def resourceId: ResourceId
    def firewallFailOpen: zio.aws.route53resolver.model.FirewallFailOpenStatus
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getFirewallFailOpen: ZIO[
      Any,
      Nothing,
      zio.aws.route53resolver.model.FirewallFailOpenStatus
    ] = ZIO.succeed(firewallFailOpen)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateFirewallConfigRequest
  ) extends zio.aws.route53resolver.model.UpdateFirewallConfigRequest.ReadOnly {
    override val resourceId: ResourceId =
      zio.aws.route53resolver.model.primitives.ResourceId(impl.resourceId())
    override val firewallFailOpen
        : zio.aws.route53resolver.model.FirewallFailOpenStatus =
      zio.aws.route53resolver.model.FirewallFailOpenStatus
        .wrap(impl.firewallFailOpen())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateFirewallConfigRequest
  ): zio.aws.route53resolver.model.UpdateFirewallConfigRequest.ReadOnly =
    new Wrapper(impl)
}
