package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateResolverConfigResponse(
    resolverConfig: Optional[zio.aws.route53resolver.model.ResolverConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateResolverConfigResponse = {
    import UpdateResolverConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateResolverConfigResponse
      .builder()
      .optionallyWith(resolverConfig.map(value => value.buildAwsValue()))(
        _.resolverConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateResolverConfigResponse.ReadOnly =
    zio.aws.route53resolver.model.UpdateResolverConfigResponse
      .wrap(buildAwsValue())
}
object UpdateResolverConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateResolverConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.UpdateResolverConfigResponse =
      zio.aws.route53resolver.model.UpdateResolverConfigResponse(
        resolverConfig.map(value => value.asEditable)
      )
    def resolverConfig
        : Optional[zio.aws.route53resolver.model.ResolverConfig.ReadOnly]
    def getResolverConfig: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverConfig.ReadOnly
    ] = AwsError.unwrapOptionField("resolverConfig", resolverConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateResolverConfigResponse
  ) extends zio.aws.route53resolver.model.UpdateResolverConfigResponse.ReadOnly {
    override val resolverConfig
        : Optional[zio.aws.route53resolver.model.ResolverConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolverConfig())
        .map(value => zio.aws.route53resolver.model.ResolverConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateResolverConfigResponse
  ): zio.aws.route53resolver.model.UpdateResolverConfigResponse.ReadOnly =
    new Wrapper(impl)
}
