package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class GetResolverQueryLogConfigRequest(
    resolverQueryLogConfigId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigRequest = {
    import GetResolverQueryLogConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigRequest
      .builder()
      .resolverQueryLogConfigId(
        ResourceId.unwrap(resolverQueryLogConfigId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetResolverQueryLogConfigRequest.ReadOnly =
    zio.aws.route53resolver.model.GetResolverQueryLogConfigRequest
      .wrap(buildAwsValue())
}
object GetResolverQueryLogConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.GetResolverQueryLogConfigRequest =
      zio.aws.route53resolver.model
        .GetResolverQueryLogConfigRequest(resolverQueryLogConfigId)
    def resolverQueryLogConfigId: ResourceId
    def getResolverQueryLogConfigId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(resolverQueryLogConfigId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigRequest
  ) extends zio.aws.route53resolver.model.GetResolverQueryLogConfigRequest.ReadOnly {
    override val resolverQueryLogConfigId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.resolverQueryLogConfigId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigRequest
  ): zio.aws.route53resolver.model.GetResolverQueryLogConfigRequest.ReadOnly =
    new Wrapper(impl)
}
