package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteFirewallRuleResponse(
    firewallRule: Optional[zio.aws.route53resolver.model.FirewallRule] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleResponse = {
    import DeleteFirewallRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleResponse
      .builder()
      .optionallyWith(firewallRule.map(value => value.buildAwsValue()))(
        _.firewallRule
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.DeleteFirewallRuleResponse.ReadOnly =
    zio.aws.route53resolver.model.DeleteFirewallRuleResponse
      .wrap(buildAwsValue())
}
object DeleteFirewallRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.DeleteFirewallRuleResponse =
      zio.aws.route53resolver.model
        .DeleteFirewallRuleResponse(firewallRule.map(value => value.asEditable))
    def firewallRule
        : Optional[zio.aws.route53resolver.model.FirewallRule.ReadOnly]
    def getFirewallRule: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallRule.ReadOnly
    ] = AwsError.unwrapOptionField("firewallRule", firewallRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleResponse
  ) extends zio.aws.route53resolver.model.DeleteFirewallRuleResponse.ReadOnly {
    override val firewallRule
        : Optional[zio.aws.route53resolver.model.FirewallRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallRule())
        .map(value => zio.aws.route53resolver.model.FirewallRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleResponse
  ): zio.aws.route53resolver.model.DeleteFirewallRuleResponse.ReadOnly =
    new Wrapper(impl)
}
