package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{
  NextToken,
  MaxResults,
  Priority,
  ResourceId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListFirewallRuleGroupAssociationsRequest(
    firewallRuleGroupId: Optional[ResourceId] = Optional.Absent,
    vpcId: Optional[ResourceId] = Optional.Absent,
    priority: Optional[Priority] = Optional.Absent,
    status: Optional[
      zio.aws.route53resolver.model.FirewallRuleGroupAssociationStatus
    ] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest = {
    import ListFirewallRuleGroupAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest
      .builder()
      .optionallyWith(
        firewallRuleGroupId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.firewallRuleGroupId)
      .optionallyWith(
        vpcId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(priority.map(value => Priority.unwrap(value): Integer))(
        _.priority
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListFirewallRuleGroupAssociationsRequest.ReadOnly =
    zio.aws.route53resolver.model.ListFirewallRuleGroupAssociationsRequest
      .wrap(buildAwsValue())
}
object ListFirewallRuleGroupAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ListFirewallRuleGroupAssociationsRequest =
      zio.aws.route53resolver.model.ListFirewallRuleGroupAssociationsRequest(
        firewallRuleGroupId.map(value => value),
        vpcId.map(value => value),
        priority.map(value => value),
        status.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def firewallRuleGroupId: Optional[ResourceId]
    def vpcId: Optional[ResourceId]
    def priority: Optional[Priority]
    def status: Optional[
      zio.aws.route53resolver.model.FirewallRuleGroupAssociationStatus
    ]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getFirewallRuleGroupId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("firewallRuleGroupId", firewallRuleGroupId)
    def getVpcId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getPriority: ZIO[Any, AwsError, Priority] =
      AwsError.unwrapOptionField("priority", priority)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallRuleGroupAssociationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest
  ) extends zio.aws.route53resolver.model.ListFirewallRuleGroupAssociationsRequest.ReadOnly {
    override val firewallRuleGroupId: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallRuleGroupId())
        .map(value =>
          zio.aws.route53resolver.model.primitives.ResourceId(value)
        )
    override val vpcId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val priority: Optional[Priority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.route53resolver.model.primitives.Priority(value))
    override val status: Optional[
      zio.aws.route53resolver.model.FirewallRuleGroupAssociationStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.route53resolver.model.FirewallRuleGroupAssociationStatus
          .wrap(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.route53resolver.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest
  ): zio.aws.route53resolver.model.ListFirewallRuleGroupAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
