package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{MaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListResolverRuleAssociationsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    resolverRuleAssociations: Optional[
      Iterable[zio.aws.route53resolver.model.ResolverRuleAssociation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse = {
    import ListResolverRuleAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        resolverRuleAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resolverRuleAssociations)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse.ReadOnly =
    zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse
      .wrap(buildAwsValue())
}
object ListResolverRuleAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse =
      zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse(
        nextToken.map(value => value),
        maxResults.map(value => value),
        resolverRuleAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def resolverRuleAssociations: Optional[
      List[zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getResolverRuleAssociations: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resolverRuleAssociations",
      resolverRuleAssociations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse
  ) extends zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.route53resolver.model.primitives.MaxResults(value))
    override val resolverRuleAssociations: Optional[
      List[zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resolverRuleAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.ResolverRuleAssociation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse
  ): zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
