package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{Count, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListResolverQueryLogConfigsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    totalCount: Optional[Count] = Optional.Absent,
    totalFilteredCount: Optional[Count] = Optional.Absent,
    resolverQueryLogConfigs: Optional[
      Iterable[zio.aws.route53resolver.model.ResolverQueryLogConfig]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsResponse = {
    import ListResolverQueryLogConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(totalCount.map(value => Count.unwrap(value): Integer))(
        _.totalCount
      )
      .optionallyWith(
        totalFilteredCount.map(value => Count.unwrap(value): Integer)
      )(_.totalFilteredCount)
      .optionallyWith(
        resolverQueryLogConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resolverQueryLogConfigs)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverQueryLogConfigsResponse.ReadOnly =
    zio.aws.route53resolver.model.ListResolverQueryLogConfigsResponse
      .wrap(buildAwsValue())
}
object ListResolverQueryLogConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ListResolverQueryLogConfigsResponse =
      zio.aws.route53resolver.model.ListResolverQueryLogConfigsResponse(
        nextToken.map(value => value),
        totalCount.map(value => value),
        totalFilteredCount.map(value => value),
        resolverQueryLogConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def totalCount: Optional[Count]
    def totalFilteredCount: Optional[Count]
    def resolverQueryLogConfigs: Optional[
      List[zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTotalCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("totalCount", totalCount)
    def getTotalFilteredCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("totalFilteredCount", totalFilteredCount)
    def getResolverQueryLogConfigs: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resolverQueryLogConfigs",
      resolverQueryLogConfigs
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsResponse
  ) extends zio.aws.route53resolver.model.ListResolverQueryLogConfigsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val totalCount: Optional[Count] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCount())
      .map(value => zio.aws.route53resolver.model.primitives.Count(value))
    override val totalFilteredCount: Optional[Count] = zio.aws.core.internal
      .optionalFromNullable(impl.totalFilteredCount())
      .map(value => zio.aws.route53resolver.model.primitives.Count(value))
    override val resolverQueryLogConfigs: Optional[
      List[zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resolverQueryLogConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.ResolverQueryLogConfig.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsResponse
  ): zio.aws.route53resolver.model.ListResolverQueryLogConfigsResponse.ReadOnly =
    new Wrapper(impl)
}
