package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{MaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListResolverEndpointIpAddressesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    ipAddresses: Optional[
      Iterable[zio.aws.route53resolver.model.IpAddressResponse]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse = {
    import ListResolverEndpointIpAddressesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        ipAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipAddresses)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse.ReadOnly =
    zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse
      .wrap(buildAwsValue())
}
object ListResolverEndpointIpAddressesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse =
      zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse(
        nextToken.map(value => value),
        maxResults.map(value => value),
        ipAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def ipAddresses: Optional[
      List[zio.aws.route53resolver.model.IpAddressResponse.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getIpAddresses: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.IpAddressResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("ipAddresses", ipAddresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse
  ) extends zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.route53resolver.model.primitives.MaxResults(value))
    override val ipAddresses: Optional[
      List[zio.aws.route53resolver.model.IpAddressResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.IpAddressResponse.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse
  ): zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse.ReadOnly =
    new Wrapper(impl)
}
