package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{
  NextToken,
  ListDomainMaxResults,
  ResourceId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListFirewallDomainsRequest(
    firewallDomainListId: ResourceId,
    maxResults: Optional[ListDomainMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsRequest = {
    import ListFirewallDomainsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsRequest
      .builder()
      .firewallDomainListId(
        ResourceId.unwrap(firewallDomainListId): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => ListDomainMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListFirewallDomainsRequest.ReadOnly =
    zio.aws.route53resolver.model.ListFirewallDomainsRequest
      .wrap(buildAwsValue())
}
object ListFirewallDomainsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ListFirewallDomainsRequest =
      zio.aws.route53resolver.model.ListFirewallDomainsRequest(
        firewallDomainListId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def firewallDomainListId: ResourceId
    def maxResults: Optional[ListDomainMaxResults]
    def nextToken: Optional[NextToken]
    def getFirewallDomainListId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallDomainListId)
    def getMaxResults: ZIO[Any, AwsError, ListDomainMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsRequest
  ) extends zio.aws.route53resolver.model.ListFirewallDomainsRequest.ReadOnly {
    override val firewallDomainListId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.firewallDomainListId())
    override val maxResults: Optional[ListDomainMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.route53resolver.model.primitives.ListDomainMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsRequest
  ): zio.aws.route53resolver.model.ListFirewallDomainsRequest.ReadOnly =
    new Wrapper(impl)
}
