package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{Name, Priority, ResourceId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateFirewallRuleGroupAssociationRequest(
    firewallRuleGroupAssociationId: ResourceId,
    priority: Optional[Priority] = Optional.Absent,
    mutationProtection: Optional[
      zio.aws.route53resolver.model.MutationProtectionStatus
    ] = Optional.Absent,
    name: Optional[Name] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleGroupAssociationRequest = {
    import UpdateFirewallRuleGroupAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleGroupAssociationRequest
      .builder()
      .firewallRuleGroupAssociationId(
        ResourceId.unwrap(firewallRuleGroupAssociationId): java.lang.String
      )
      .optionallyWith(priority.map(value => Priority.unwrap(value): Integer))(
        _.priority
      )
      .optionallyWith(mutationProtection.map(value => value.unwrap))(
        _.mutationProtection
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateFirewallRuleGroupAssociationRequest.ReadOnly =
    zio.aws.route53resolver.model.UpdateFirewallRuleGroupAssociationRequest
      .wrap(buildAwsValue())
}
object UpdateFirewallRuleGroupAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleGroupAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.UpdateFirewallRuleGroupAssociationRequest =
      zio.aws.route53resolver.model.UpdateFirewallRuleGroupAssociationRequest(
        firewallRuleGroupAssociationId,
        priority.map(value => value),
        mutationProtection.map(value => value),
        name.map(value => value)
      )
    def firewallRuleGroupAssociationId: ResourceId
    def priority: Optional[Priority]
    def mutationProtection
        : Optional[zio.aws.route53resolver.model.MutationProtectionStatus]
    def name: Optional[Name]
    def getFirewallRuleGroupAssociationId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallRuleGroupAssociationId)
    def getPriority: ZIO[Any, AwsError, Priority] =
      AwsError.unwrapOptionField("priority", priority)
    def getMutationProtection: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.MutationProtectionStatus
    ] = AwsError.unwrapOptionField("mutationProtection", mutationProtection)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleGroupAssociationRequest
  ) extends zio.aws.route53resolver.model.UpdateFirewallRuleGroupAssociationRequest.ReadOnly {
    override val firewallRuleGroupAssociationId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.firewallRuleGroupAssociationId())
    override val priority: Optional[Priority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.route53resolver.model.primitives.Priority(value))
    override val mutationProtection
        : Optional[zio.aws.route53resolver.model.MutationProtectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mutationProtection())
        .map(value =>
          zio.aws.route53resolver.model.MutationProtectionStatus.wrap(value)
        )
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleGroupAssociationRequest
  ): zio.aws.route53resolver.model.UpdateFirewallRuleGroupAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
