package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetResolverQueryLogConfigAssociationResponse(
    resolverQueryLogConfigAssociation: Optional[
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigAssociationResponse = {
    import GetResolverQueryLogConfigAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigAssociationResponse
      .builder()
      .optionallyWith(
        resolverQueryLogConfigAssociation.map(value => value.buildAwsValue())
      )(_.resolverQueryLogConfigAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetResolverQueryLogConfigAssociationResponse.ReadOnly =
    zio.aws.route53resolver.model.GetResolverQueryLogConfigAssociationResponse
      .wrap(buildAwsValue())
}
object GetResolverQueryLogConfigAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.GetResolverQueryLogConfigAssociationResponse =
      zio.aws.route53resolver.model
        .GetResolverQueryLogConfigAssociationResponse(
          resolverQueryLogConfigAssociation.map(value => value.asEditable)
        )
    def resolverQueryLogConfigAssociation: Optional[
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation.ReadOnly
    ]
    def getResolverQueryLogConfigAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resolverQueryLogConfigAssociation",
      resolverQueryLogConfigAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigAssociationResponse
  ) extends zio.aws.route53resolver.model.GetResolverQueryLogConfigAssociationResponse.ReadOnly {
    override val resolverQueryLogConfigAssociation: Optional[
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resolverQueryLogConfigAssociation())
      .map(value =>
        zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigAssociationResponse
  ): zio.aws.route53resolver.model.GetResolverQueryLogConfigAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
