package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetResolverRuleResponse(
    resolverRule: Optional[zio.aws.route53resolver.model.ResolverRule] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetResolverRuleResponse = {
    import GetResolverRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetResolverRuleResponse
      .builder()
      .optionallyWith(resolverRule.map(value => value.buildAwsValue()))(
        _.resolverRule
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetResolverRuleResponse.ReadOnly =
    zio.aws.route53resolver.model.GetResolverRuleResponse.wrap(buildAwsValue())
}
object GetResolverRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetResolverRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.GetResolverRuleResponse =
      zio.aws.route53resolver.model
        .GetResolverRuleResponse(resolverRule.map(value => value.asEditable))
    def resolverRule
        : Optional[zio.aws.route53resolver.model.ResolverRule.ReadOnly]
    def getResolverRule: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverRule.ReadOnly
    ] = AwsError.unwrapOptionField("resolverRule", resolverRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverRuleResponse
  ) extends zio.aws.route53resolver.model.GetResolverRuleResponse.ReadOnly {
    override val resolverRule
        : Optional[zio.aws.route53resolver.model.ResolverRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolverRule())
        .map(value => zio.aws.route53resolver.model.ResolverRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverRuleResponse
  ): zio.aws.route53resolver.model.GetResolverRuleResponse.ReadOnly =
    new Wrapper(impl)
}
