package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{
  NextToken,
  ListResolverConfigsMaxResult
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListResolverConfigsRequest(
    maxResults: Optional[ListResolverConfigsMaxResult] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest = {
    import ListResolverConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListResolverConfigsMaxResult.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverConfigsRequest.ReadOnly =
    zio.aws.route53resolver.model.ListResolverConfigsRequest
      .wrap(buildAwsValue())
}
object ListResolverConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ListResolverConfigsRequest =
      zio.aws.route53resolver.model.ListResolverConfigsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListResolverConfigsMaxResult]
    def nextToken: Optional[NextToken]
    def getMaxResults: ZIO[Any, AwsError, ListResolverConfigsMaxResult] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest
  ) extends zio.aws.route53resolver.model.ListResolverConfigsRequest.ReadOnly {
    override val maxResults: Optional[ListResolverConfigsMaxResult] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.route53resolver.model.primitives
            .ListResolverConfigsMaxResult(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest
  ): zio.aws.route53resolver.model.ListResolverConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
