package zio.aws.route53resolver
import zio.aws.route53resolver.model.DeleteFirewallRuleGroupResponse.ReadOnly
import software.amazon.awssdk.services.route53resolver.Route53ResolverAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.route53resolver.model.{
  DeleteFirewallDomainListRequest,
  AssociateResolverRuleRequest,
  ListFirewallConfigsRequest,
  DeleteResolverEndpointRequest,
  GetResolverQueryLogConfigPolicyRequest,
  UpdateFirewallDomainsRequest,
  ListFirewallDomainsRequest,
  ListResolverEndpointsRequest,
  AssociateResolverEndpointIpAddressRequest,
  AssociateFirewallRuleGroupRequest,
  ListFirewallRulesRequest,
  GetResolverRulePolicyRequest,
  GetResolverConfigRequest,
  ListResolverEndpointIpAddressesRequest,
  DisassociateResolverQueryLogConfigRequest,
  UpdateResolverConfigRequest,
  PutFirewallRuleGroupPolicyRequest,
  ListResolverQueryLogConfigAssociationsRequest,
  PutResolverRulePolicyRequest,
  DisassociateResolverEndpointIpAddressRequest,
  CreateResolverQueryLogConfigRequest,
  DisassociateFirewallRuleGroupRequest,
  GetResolverQueryLogConfigAssociationRequest,
  ListTagsForResourceRequest,
  PutResolverQueryLogConfigPolicyRequest,
  ListFirewallRuleGroupsRequest,
  DeleteResolverRuleRequest,
  UpdateResolverEndpointRequest,
  GetResolverEndpointRequest,
  CreateResolverEndpointRequest,
  UpdateFirewallRuleGroupAssociationRequest,
  GetResolverRuleAssociationRequest,
  ListResolverConfigsRequest,
  UpdateFirewallRuleRequest,
  ImportFirewallDomainsRequest,
  ListFirewallRuleGroupAssociationsRequest,
  GetFirewallRuleGroupPolicyRequest,
  GetResolverDnssecConfigRequest,
  ListResolverRuleAssociationsRequest,
  CreateFirewallRuleRequest,
  DeleteFirewallRuleRequest,
  DeleteFirewallRuleGroupRequest,
  CreateFirewallDomainListRequest,
  UntagResourceRequest,
  DisassociateResolverRuleRequest,
  ListFirewallDomainListsRequest,
  CreateFirewallRuleGroupRequest,
  UpdateResolverDnssecConfigRequest,
  AssociateResolverQueryLogConfigRequest,
  GetFirewallConfigRequest,
  ListResolverRulesRequest,
  ListResolverQueryLogConfigsRequest,
  UpdateFirewallConfigRequest,
  GetFirewallDomainListRequest,
  GetFirewallRuleGroupAssociationRequest,
  GetResolverRuleRequest,
  TagResourceRequest,
  CreateResolverRuleRequest,
  GetResolverQueryLogConfigRequest,
  GetFirewallRuleGroupRequest,
  ListResolverDnssecConfigsRequest,
  DeleteResolverQueryLogConfigRequest,
  UpdateResolverRuleRequest
}
import zio.aws.route53resolver.model.primitives.FirewallDomainName
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object Route53ResolverMock extends Mock[Route53Resolver] {
  object UpdateFirewallConfig
      extends Effect[
        UpdateFirewallConfigRequest,
        AwsError,
        zio.aws.route53resolver.model.UpdateFirewallConfigResponse.ReadOnly
      ]
  object DeleteFirewallRuleGroup
      extends Effect[DeleteFirewallRuleGroupRequest, AwsError, ReadOnly]
  object ListFirewallDomainLists
      extends Stream[
        ListFirewallDomainListsRequest,
        AwsError,
        zio.aws.route53resolver.model.FirewallDomainListMetadata.ReadOnly
      ]
  object ListFirewallDomainListsPaginated
      extends Effect[
        ListFirewallDomainListsRequest,
        AwsError,
        zio.aws.route53resolver.model.ListFirewallDomainListsResponse.ReadOnly
      ]
  object DeleteResolverQueryLogConfig
      extends Effect[
        DeleteResolverQueryLogConfigRequest,
        AwsError,
        zio.aws.route53resolver.model.DeleteResolverQueryLogConfigResponse.ReadOnly
      ]
  object GetResolverQueryLogConfig
      extends Effect[
        GetResolverQueryLogConfigRequest,
        AwsError,
        zio.aws.route53resolver.model.GetResolverQueryLogConfigResponse.ReadOnly
      ]
  object CreateFirewallRule
      extends Effect[
        CreateFirewallRuleRequest,
        AwsError,
        zio.aws.route53resolver.model.CreateFirewallRuleResponse.ReadOnly
      ]
  object UpdateResolverConfig
      extends Effect[
        UpdateResolverConfigRequest,
        AwsError,
        zio.aws.route53resolver.model.UpdateResolverConfigResponse.ReadOnly
      ]
  object ListResolverEndpointIpAddresses
      extends Effect[
        ListResolverEndpointIpAddressesRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse.ReadOnly,
          zio.aws.route53resolver.model.IpAddressResponse.ReadOnly
        ]
      ]
  object ListResolverEndpointIpAddressesPaginated
      extends Effect[
        ListResolverEndpointIpAddressesRequest,
        AwsError,
        zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse.ReadOnly
      ]
  object ListResolverEndpoints
      extends Effect[
        ListResolverEndpointsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.route53resolver.model.ListResolverEndpointsResponse.ReadOnly,
          zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly
        ]
      ]
  object ListResolverEndpointsPaginated
      extends Effect[
        ListResolverEndpointsRequest,
        AwsError,
        zio.aws.route53resolver.model.ListResolverEndpointsResponse.ReadOnly
      ]
  object ListResolverRules
      extends Effect[ListResolverRulesRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.route53resolver.model.ListResolverRulesResponse.ReadOnly,
        zio.aws.route53resolver.model.ResolverRule.ReadOnly
      ]]
  object ListResolverRulesPaginated
      extends Effect[
        ListResolverRulesRequest,
        AwsError,
        zio.aws.route53resolver.model.ListResolverRulesResponse.ReadOnly
      ]
  object DeleteFirewallRule
      extends Effect[
        DeleteFirewallRuleRequest,
        AwsError,
        zio.aws.route53resolver.model.DeleteFirewallRuleResponse.ReadOnly
      ]
  object AssociateResolverQueryLogConfig
      extends Effect[
        AssociateResolverQueryLogConfigRequest,
        AwsError,
        zio.aws.route53resolver.model.AssociateResolverQueryLogConfigResponse.ReadOnly
      ]
  object ListFirewallDomains
      extends Stream[ListFirewallDomainsRequest, AwsError, FirewallDomainName]
  object ListFirewallDomainsPaginated
      extends Effect[
        ListFirewallDomainsRequest,
        AwsError,
        zio.aws.route53resolver.model.ListFirewallDomainsResponse.ReadOnly
      ]
  object GetFirewallDomainList
      extends Effect[
        GetFirewallDomainListRequest,
        AwsError,
        zio.aws.route53resolver.model.GetFirewallDomainListResponse.ReadOnly
      ]
  object CreateFirewallRuleGroup
      extends Effect[
        CreateFirewallRuleGroupRequest,
        AwsError,
        zio.aws.route53resolver.model.CreateFirewallRuleGroupResponse.ReadOnly
      ]
  object DisassociateResolverEndpointIpAddress
      extends Effect[
        DisassociateResolverEndpointIpAddressRequest,
        AwsError,
        zio.aws.route53resolver.model.DisassociateResolverEndpointIpAddressResponse.ReadOnly
      ]
  object UpdateResolverRule
      extends Effect[
        UpdateResolverRuleRequest,
        AwsError,
        zio.aws.route53resolver.model.UpdateResolverRuleResponse.ReadOnly
      ]
  object CreateResolverEndpoint
      extends Effect[
        CreateResolverEndpointRequest,
        AwsError,
        zio.aws.route53resolver.model.CreateResolverEndpointResponse.ReadOnly
      ]
  object ListResolverRuleAssociations
      extends Effect[
        ListResolverRuleAssociationsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse.ReadOnly,
          zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly
        ]
      ]
  object ListResolverRuleAssociationsPaginated
      extends Effect[
        ListResolverRuleAssociationsRequest,
        AwsError,
        zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse.ReadOnly
      ]
  object UpdateResolverEndpoint
      extends Effect[
        UpdateResolverEndpointRequest,
        AwsError,
        zio.aws.route53resolver.model.UpdateResolverEndpointResponse.ReadOnly
      ]
  object PutResolverRulePolicy
      extends Effect[
        PutResolverRulePolicyRequest,
        AwsError,
        zio.aws.route53resolver.model.PutResolverRulePolicyResponse.ReadOnly
      ]
  object GetFirewallRuleGroupPolicy
      extends Effect[
        GetFirewallRuleGroupPolicyRequest,
        AwsError,
        zio.aws.route53resolver.model.GetFirewallRuleGroupPolicyResponse.ReadOnly
      ]
  object GetResolverRuleAssociation
      extends Effect[
        GetResolverRuleAssociationRequest,
        AwsError,
        zio.aws.route53resolver.model.GetResolverRuleAssociationResponse.ReadOnly
      ]
  object DisassociateFirewallRuleGroup
      extends Effect[
        DisassociateFirewallRuleGroupRequest,
        AwsError,
        zio.aws.route53resolver.model.DisassociateFirewallRuleGroupResponse.ReadOnly
      ]
  object AssociateFirewallRuleGroup
      extends Effect[
        AssociateFirewallRuleGroupRequest,
        AwsError,
        zio.aws.route53resolver.model.AssociateFirewallRuleGroupResponse.ReadOnly
      ]
  object DisassociateResolverRule
      extends Effect[
        DisassociateResolverRuleRequest,
        AwsError,
        zio.aws.route53resolver.model.DisassociateResolverRuleResponse.ReadOnly
      ]
  object GetResolverDnssecConfig
      extends Effect[
        GetResolverDnssecConfigRequest,
        AwsError,
        zio.aws.route53resolver.model.GetResolverDnssecConfigResponse.ReadOnly
      ]
  object ListResolverDnssecConfigs
      extends Stream[
        ListResolverDnssecConfigsRequest,
        AwsError,
        zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly
      ]
  object ListResolverDnssecConfigsPaginated
      extends Effect[
        ListResolverDnssecConfigsRequest,
        AwsError,
        zio.aws.route53resolver.model.ListResolverDnssecConfigsResponse.ReadOnly
      ]
  object GetResolverRule
      extends Effect[
        GetResolverRuleRequest,
        AwsError,
        zio.aws.route53resolver.model.GetResolverRuleResponse.ReadOnly
      ]
  object DisassociateResolverQueryLogConfig
      extends Effect[
        DisassociateResolverQueryLogConfigRequest,
        AwsError,
        zio.aws.route53resolver.model.DisassociateResolverQueryLogConfigResponse.ReadOnly
      ]
  object ListFirewallConfigs
      extends Stream[
        ListFirewallConfigsRequest,
        AwsError,
        zio.aws.route53resolver.model.FirewallConfig.ReadOnly
      ]
  object ListFirewallConfigsPaginated
      extends Effect[
        ListFirewallConfigsRequest,
        AwsError,
        zio.aws.route53resolver.model.ListFirewallConfigsResponse.ReadOnly
      ]
  object UpdateFirewallRuleGroupAssociation
      extends Effect[
        UpdateFirewallRuleGroupAssociationRequest,
        AwsError,
        zio.aws.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse.ReadOnly
      ]
  object UpdateFirewallDomains
      extends Effect[
        UpdateFirewallDomainsRequest,
        AwsError,
        zio.aws.route53resolver.model.UpdateFirewallDomainsResponse.ReadOnly
      ]
  object GetResolverRulePolicy
      extends Effect[
        GetResolverRulePolicyRequest,
        AwsError,
        zio.aws.route53resolver.model.GetResolverRulePolicyResponse.ReadOnly
      ]
  object CreateResolverQueryLogConfig
      extends Effect[
        CreateResolverQueryLogConfigRequest,
        AwsError,
        zio.aws.route53resolver.model.CreateResolverQueryLogConfigResponse.ReadOnly
      ]
  object DeleteFirewallDomainList
      extends Effect[
        DeleteFirewallDomainListRequest,
        AwsError,
        zio.aws.route53resolver.model.DeleteFirewallDomainListResponse.ReadOnly
      ]
  object GetResolverEndpoint
      extends Effect[
        GetResolverEndpointRequest,
        AwsError,
        zio.aws.route53resolver.model.GetResolverEndpointResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.route53resolver.model.UntagResourceResponse.ReadOnly
      ]
  object GetResolverQueryLogConfigAssociation
      extends Effect[
        GetResolverQueryLogConfigAssociationRequest,
        AwsError,
        zio.aws.route53resolver.model.GetResolverQueryLogConfigAssociationResponse.ReadOnly
      ]
  object ListResolverConfigs
      extends Stream[
        ListResolverConfigsRequest,
        AwsError,
        zio.aws.route53resolver.model.ResolverConfig.ReadOnly
      ]
  object ListResolverConfigsPaginated
      extends Effect[
        ListResolverConfigsRequest,
        AwsError,
        zio.aws.route53resolver.model.ListResolverConfigsResponse.ReadOnly
      ]
  object ListResolverQueryLogConfigs
      extends Effect[
        ListResolverQueryLogConfigsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.route53resolver.model.ListResolverQueryLogConfigsResponse.ReadOnly,
          zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly
        ]
      ]
  object ListResolverQueryLogConfigsPaginated
      extends Effect[
        ListResolverQueryLogConfigsRequest,
        AwsError,
        zio.aws.route53resolver.model.ListResolverQueryLogConfigsResponse.ReadOnly
      ]
  object ListResolverQueryLogConfigAssociations
      extends Effect[
        ListResolverQueryLogConfigAssociationsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse.ReadOnly,
          zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation.ReadOnly
        ]
      ]
  object ListResolverQueryLogConfigAssociationsPaginated
      extends Effect[
        ListResolverQueryLogConfigAssociationsRequest,
        AwsError,
        zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse.ReadOnly
      ]
  object PutFirewallRuleGroupPolicy
      extends Effect[
        PutFirewallRuleGroupPolicyRequest,
        AwsError,
        zio.aws.route53resolver.model.PutFirewallRuleGroupPolicyResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.route53resolver.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.route53resolver.model.ListTagsForResourceResponse.ReadOnly
      ]
  object GetFirewallRuleGroupAssociation
      extends Effect[
        GetFirewallRuleGroupAssociationRequest,
        AwsError,
        zio.aws.route53resolver.model.GetFirewallRuleGroupAssociationResponse.ReadOnly
      ]
  object AssociateResolverEndpointIpAddress
      extends Effect[
        AssociateResolverEndpointIpAddressRequest,
        AwsError,
        zio.aws.route53resolver.model.AssociateResolverEndpointIpAddressResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.route53resolver.model.TagResourceResponse.ReadOnly
      ]
  object ImportFirewallDomains
      extends Effect[
        ImportFirewallDomainsRequest,
        AwsError,
        zio.aws.route53resolver.model.ImportFirewallDomainsResponse.ReadOnly
      ]
  object DeleteResolverEndpoint
      extends Effect[
        DeleteResolverEndpointRequest,
        AwsError,
        zio.aws.route53resolver.model.DeleteResolverEndpointResponse.ReadOnly
      ]
  object ListFirewallRuleGroupAssociations
      extends Stream[
        ListFirewallRuleGroupAssociationsRequest,
        AwsError,
        zio.aws.route53resolver.model.FirewallRuleGroupAssociation.ReadOnly
      ]
  object ListFirewallRuleGroupAssociationsPaginated
      extends Effect[
        ListFirewallRuleGroupAssociationsRequest,
        AwsError,
        zio.aws.route53resolver.model.ListFirewallRuleGroupAssociationsResponse.ReadOnly
      ]
  object ListFirewallRules
      extends Stream[
        ListFirewallRulesRequest,
        AwsError,
        zio.aws.route53resolver.model.FirewallRule.ReadOnly
      ]
  object ListFirewallRulesPaginated
      extends Effect[
        ListFirewallRulesRequest,
        AwsError,
        zio.aws.route53resolver.model.ListFirewallRulesResponse.ReadOnly
      ]
  object ListFirewallRuleGroups
      extends Stream[
        ListFirewallRuleGroupsRequest,
        AwsError,
        zio.aws.route53resolver.model.FirewallRuleGroupMetadata.ReadOnly
      ]
  object ListFirewallRuleGroupsPaginated
      extends Effect[
        ListFirewallRuleGroupsRequest,
        AwsError,
        zio.aws.route53resolver.model.ListFirewallRuleGroupsResponse.ReadOnly
      ]
  object DeleteResolverRule
      extends Effect[
        DeleteResolverRuleRequest,
        AwsError,
        zio.aws.route53resolver.model.DeleteResolverRuleResponse.ReadOnly
      ]
  object GetResolverConfig
      extends Effect[
        GetResolverConfigRequest,
        AwsError,
        zio.aws.route53resolver.model.GetResolverConfigResponse.ReadOnly
      ]
  object UpdateFirewallRule
      extends Effect[
        UpdateFirewallRuleRequest,
        AwsError,
        zio.aws.route53resolver.model.UpdateFirewallRuleResponse.ReadOnly
      ]
  object GetResolverQueryLogConfigPolicy
      extends Effect[
        GetResolverQueryLogConfigPolicyRequest,
        AwsError,
        zio.aws.route53resolver.model.GetResolverQueryLogConfigPolicyResponse.ReadOnly
      ]
  object CreateFirewallDomainList
      extends Effect[
        CreateFirewallDomainListRequest,
        AwsError,
        zio.aws.route53resolver.model.CreateFirewallDomainListResponse.ReadOnly
      ]
  object GetFirewallConfig
      extends Effect[
        GetFirewallConfigRequest,
        AwsError,
        zio.aws.route53resolver.model.GetFirewallConfigResponse.ReadOnly
      ]
  object UpdateResolverDnssecConfig
      extends Effect[
        UpdateResolverDnssecConfigRequest,
        AwsError,
        zio.aws.route53resolver.model.UpdateResolverDnssecConfigResponse.ReadOnly
      ]
  object AssociateResolverRule
      extends Effect[
        AssociateResolverRuleRequest,
        AwsError,
        zio.aws.route53resolver.model.AssociateResolverRuleResponse.ReadOnly
      ]
  object CreateResolverRule
      extends Effect[
        CreateResolverRuleRequest,
        AwsError,
        zio.aws.route53resolver.model.CreateResolverRuleResponse.ReadOnly
      ]
  object PutResolverQueryLogConfigPolicy
      extends Effect[
        PutResolverQueryLogConfigPolicyRequest,
        AwsError,
        zio.aws.route53resolver.model.PutResolverQueryLogConfigPolicyResponse.ReadOnly
      ]
  object GetFirewallRuleGroup
      extends Effect[
        GetFirewallRuleGroupRequest,
        AwsError,
        zio.aws.route53resolver.model.GetFirewallRuleGroupResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Route53Resolver] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Route53Resolver] { rts =>
        ZIO.succeed {
          new Route53Resolver {
            val api: Route53ResolverAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Route53Resolver = this
            def updateFirewallConfig(request: UpdateFirewallConfigRequest): IO[
              AwsError,
              zio.aws.route53resolver.model.UpdateFirewallConfigResponse.ReadOnly
            ] = proxy(UpdateFirewallConfig, request)
            def deleteFirewallRuleGroup(
                request: DeleteFirewallRuleGroupRequest
            ): IO[AwsError, ReadOnly] = proxy(DeleteFirewallRuleGroup, request)
            def listFirewallDomainLists(
                request: ListFirewallDomainListsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.route53resolver.model.FirewallDomainListMetadata.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFirewallDomainLists, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFirewallDomainListsPaginated(
                request: ListFirewallDomainListsRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.ListFirewallDomainListsResponse.ReadOnly
            ] = proxy(ListFirewallDomainListsPaginated, request)
            def deleteResolverQueryLogConfig(
                request: DeleteResolverQueryLogConfigRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.DeleteResolverQueryLogConfigResponse.ReadOnly
            ] = proxy(DeleteResolverQueryLogConfig, request)
            def getResolverQueryLogConfig(
                request: GetResolverQueryLogConfigRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.GetResolverQueryLogConfigResponse.ReadOnly
            ] = proxy(GetResolverQueryLogConfig, request)
            def createFirewallRule(request: CreateFirewallRuleRequest): IO[
              AwsError,
              zio.aws.route53resolver.model.CreateFirewallRuleResponse.ReadOnly
            ] = proxy(CreateFirewallRule, request)
            def updateResolverConfig(request: UpdateResolverConfigRequest): IO[
              AwsError,
              zio.aws.route53resolver.model.UpdateResolverConfigResponse.ReadOnly
            ] = proxy(UpdateResolverConfig, request)
            def listResolverEndpointIpAddresses(
                request: ListResolverEndpointIpAddressesRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse.ReadOnly,
              zio.aws.route53resolver.model.IpAddressResponse.ReadOnly
            ]] = proxy(ListResolverEndpointIpAddresses, request)
            def listResolverEndpointIpAddressesPaginated(
                request: ListResolverEndpointIpAddressesRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse.ReadOnly
            ] = proxy(ListResolverEndpointIpAddressesPaginated, request)
            def listResolverEndpoints(
                request: ListResolverEndpointsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.route53resolver.model.ListResolverEndpointsResponse.ReadOnly,
              zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly
            ]] = proxy(ListResolverEndpoints, request)
            def listResolverEndpointsPaginated(
                request: ListResolverEndpointsRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.ListResolverEndpointsResponse.ReadOnly
            ] = proxy(ListResolverEndpointsPaginated, request)
            def listResolverRules(
                request: ListResolverRulesRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.route53resolver.model.ListResolverRulesResponse.ReadOnly,
              zio.aws.route53resolver.model.ResolverRule.ReadOnly
            ]] = proxy(ListResolverRules, request)
            def listResolverRulesPaginated(
                request: ListResolverRulesRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.ListResolverRulesResponse.ReadOnly
            ] = proxy(ListResolverRulesPaginated, request)
            def deleteFirewallRule(request: DeleteFirewallRuleRequest): IO[
              AwsError,
              zio.aws.route53resolver.model.DeleteFirewallRuleResponse.ReadOnly
            ] = proxy(DeleteFirewallRule, request)
            def associateResolverQueryLogConfig(
                request: AssociateResolverQueryLogConfigRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.AssociateResolverQueryLogConfigResponse.ReadOnly
            ] = proxy(AssociateResolverQueryLogConfig, request)
            def listFirewallDomains(
                request: ListFirewallDomainsRequest
            ): ZStream[Any, AwsError, FirewallDomainName] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListFirewallDomains, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listFirewallDomainsPaginated(
                request: ListFirewallDomainsRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.ListFirewallDomainsResponse.ReadOnly
            ] = proxy(ListFirewallDomainsPaginated, request)
            def getFirewallDomainList(
                request: GetFirewallDomainListRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.GetFirewallDomainListResponse.ReadOnly
            ] = proxy(GetFirewallDomainList, request)
            def createFirewallRuleGroup(
                request: CreateFirewallRuleGroupRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.CreateFirewallRuleGroupResponse.ReadOnly
            ] = proxy(CreateFirewallRuleGroup, request)
            def disassociateResolverEndpointIpAddress(
                request: DisassociateResolverEndpointIpAddressRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.DisassociateResolverEndpointIpAddressResponse.ReadOnly
            ] = proxy(DisassociateResolverEndpointIpAddress, request)
            def updateResolverRule(request: UpdateResolverRuleRequest): IO[
              AwsError,
              zio.aws.route53resolver.model.UpdateResolverRuleResponse.ReadOnly
            ] = proxy(UpdateResolverRule, request)
            def createResolverEndpoint(
                request: CreateResolverEndpointRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.CreateResolverEndpointResponse.ReadOnly
            ] = proxy(CreateResolverEndpoint, request)
            def listResolverRuleAssociations(
                request: ListResolverRuleAssociationsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse.ReadOnly,
              zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly
            ]] = proxy(ListResolverRuleAssociations, request)
            def listResolverRuleAssociationsPaginated(
                request: ListResolverRuleAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse.ReadOnly
            ] = proxy(ListResolverRuleAssociationsPaginated, request)
            def updateResolverEndpoint(
                request: UpdateResolverEndpointRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.UpdateResolverEndpointResponse.ReadOnly
            ] = proxy(UpdateResolverEndpoint, request)
            def putResolverRulePolicy(
                request: PutResolverRulePolicyRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.PutResolverRulePolicyResponse.ReadOnly
            ] = proxy(PutResolverRulePolicy, request)
            def getFirewallRuleGroupPolicy(
                request: GetFirewallRuleGroupPolicyRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.GetFirewallRuleGroupPolicyResponse.ReadOnly
            ] = proxy(GetFirewallRuleGroupPolicy, request)
            def getResolverRuleAssociation(
                request: GetResolverRuleAssociationRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.GetResolverRuleAssociationResponse.ReadOnly
            ] = proxy(GetResolverRuleAssociation, request)
            def disassociateFirewallRuleGroup(
                request: DisassociateFirewallRuleGroupRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.DisassociateFirewallRuleGroupResponse.ReadOnly
            ] = proxy(DisassociateFirewallRuleGroup, request)
            def associateFirewallRuleGroup(
                request: AssociateFirewallRuleGroupRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.AssociateFirewallRuleGroupResponse.ReadOnly
            ] = proxy(AssociateFirewallRuleGroup, request)
            def disassociateResolverRule(
                request: DisassociateResolverRuleRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.DisassociateResolverRuleResponse.ReadOnly
            ] = proxy(DisassociateResolverRule, request)
            def getResolverDnssecConfig(
                request: GetResolverDnssecConfigRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.GetResolverDnssecConfigResponse.ReadOnly
            ] = proxy(GetResolverDnssecConfig, request)
            def listResolverDnssecConfigs(
                request: ListResolverDnssecConfigsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListResolverDnssecConfigs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listResolverDnssecConfigsPaginated(
                request: ListResolverDnssecConfigsRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.ListResolverDnssecConfigsResponse.ReadOnly
            ] = proxy(ListResolverDnssecConfigsPaginated, request)
            def getResolverRule(request: GetResolverRuleRequest): IO[
              AwsError,
              zio.aws.route53resolver.model.GetResolverRuleResponse.ReadOnly
            ] = proxy(GetResolverRule, request)
            def disassociateResolverQueryLogConfig(
                request: DisassociateResolverQueryLogConfigRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.DisassociateResolverQueryLogConfigResponse.ReadOnly
            ] = proxy(DisassociateResolverQueryLogConfig, request)
            def listFirewallConfigs(
                request: ListFirewallConfigsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.route53resolver.model.FirewallConfig.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFirewallConfigs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFirewallConfigsPaginated(
                request: ListFirewallConfigsRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.ListFirewallConfigsResponse.ReadOnly
            ] = proxy(ListFirewallConfigsPaginated, request)
            def updateFirewallRuleGroupAssociation(
                request: UpdateFirewallRuleGroupAssociationRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse.ReadOnly
            ] = proxy(UpdateFirewallRuleGroupAssociation, request)
            def updateFirewallDomains(
                request: UpdateFirewallDomainsRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.UpdateFirewallDomainsResponse.ReadOnly
            ] = proxy(UpdateFirewallDomains, request)
            def getResolverRulePolicy(
                request: GetResolverRulePolicyRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.GetResolverRulePolicyResponse.ReadOnly
            ] = proxy(GetResolverRulePolicy, request)
            def createResolverQueryLogConfig(
                request: CreateResolverQueryLogConfigRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.CreateResolverQueryLogConfigResponse.ReadOnly
            ] = proxy(CreateResolverQueryLogConfig, request)
            def deleteFirewallDomainList(
                request: DeleteFirewallDomainListRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.DeleteFirewallDomainListResponse.ReadOnly
            ] = proxy(DeleteFirewallDomainList, request)
            def getResolverEndpoint(request: GetResolverEndpointRequest): IO[
              AwsError,
              zio.aws.route53resolver.model.GetResolverEndpointResponse.ReadOnly
            ] = proxy(GetResolverEndpoint, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.route53resolver.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def getResolverQueryLogConfigAssociation(
                request: GetResolverQueryLogConfigAssociationRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.GetResolverQueryLogConfigAssociationResponse.ReadOnly
            ] = proxy(GetResolverQueryLogConfigAssociation, request)
            def listResolverConfigs(
                request: ListResolverConfigsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.route53resolver.model.ResolverConfig.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListResolverConfigs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listResolverConfigsPaginated(
                request: ListResolverConfigsRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.ListResolverConfigsResponse.ReadOnly
            ] = proxy(ListResolverConfigsPaginated, request)
            def listResolverQueryLogConfigs(
                request: ListResolverQueryLogConfigsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.route53resolver.model.ListResolverQueryLogConfigsResponse.ReadOnly,
              zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly
            ]] = proxy(ListResolverQueryLogConfigs, request)
            def listResolverQueryLogConfigsPaginated(
                request: ListResolverQueryLogConfigsRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.ListResolverQueryLogConfigsResponse.ReadOnly
            ] = proxy(ListResolverQueryLogConfigsPaginated, request)
            def listResolverQueryLogConfigAssociations(
                request: ListResolverQueryLogConfigAssociationsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse.ReadOnly,
              zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation.ReadOnly
            ]] = proxy(ListResolverQueryLogConfigAssociations, request)
            def listResolverQueryLogConfigAssociationsPaginated(
                request: ListResolverQueryLogConfigAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse.ReadOnly
            ] = proxy(ListResolverQueryLogConfigAssociationsPaginated, request)
            def putFirewallRuleGroupPolicy(
                request: PutFirewallRuleGroupPolicyRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.PutFirewallRuleGroupPolicyResponse.ReadOnly
            ] = proxy(PutFirewallRuleGroupPolicy, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.route53resolver.model.Tag.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTagsForResource, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTagsForResourcePaginated(
                request: ListTagsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResourcePaginated, request)
            def getFirewallRuleGroupAssociation(
                request: GetFirewallRuleGroupAssociationRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.GetFirewallRuleGroupAssociationResponse.ReadOnly
            ] = proxy(GetFirewallRuleGroupAssociation, request)
            def associateResolverEndpointIpAddress(
                request: AssociateResolverEndpointIpAddressRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.AssociateResolverEndpointIpAddressResponse.ReadOnly
            ] = proxy(AssociateResolverEndpointIpAddress, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.route53resolver.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def importFirewallDomains(
                request: ImportFirewallDomainsRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.ImportFirewallDomainsResponse.ReadOnly
            ] = proxy(ImportFirewallDomains, request)
            def deleteResolverEndpoint(
                request: DeleteResolverEndpointRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.DeleteResolverEndpointResponse.ReadOnly
            ] = proxy(DeleteResolverEndpoint, request)
            def listFirewallRuleGroupAssociations(
                request: ListFirewallRuleGroupAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.route53resolver.model.FirewallRuleGroupAssociation.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFirewallRuleGroupAssociations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFirewallRuleGroupAssociationsPaginated(
                request: ListFirewallRuleGroupAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.ListFirewallRuleGroupAssociationsResponse.ReadOnly
            ] = proxy(ListFirewallRuleGroupAssociationsPaginated, request)
            def listFirewallRules(request: ListFirewallRulesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.route53resolver.model.FirewallRule.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFirewallRules, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFirewallRulesPaginated(
                request: ListFirewallRulesRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.ListFirewallRulesResponse.ReadOnly
            ] = proxy(ListFirewallRulesPaginated, request)
            def listFirewallRuleGroups(
                request: ListFirewallRuleGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.route53resolver.model.FirewallRuleGroupMetadata.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFirewallRuleGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFirewallRuleGroupsPaginated(
                request: ListFirewallRuleGroupsRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.ListFirewallRuleGroupsResponse.ReadOnly
            ] = proxy(ListFirewallRuleGroupsPaginated, request)
            def deleteResolverRule(request: DeleteResolverRuleRequest): IO[
              AwsError,
              zio.aws.route53resolver.model.DeleteResolverRuleResponse.ReadOnly
            ] = proxy(DeleteResolverRule, request)
            def getResolverConfig(request: GetResolverConfigRequest): IO[
              AwsError,
              zio.aws.route53resolver.model.GetResolverConfigResponse.ReadOnly
            ] = proxy(GetResolverConfig, request)
            def updateFirewallRule(request: UpdateFirewallRuleRequest): IO[
              AwsError,
              zio.aws.route53resolver.model.UpdateFirewallRuleResponse.ReadOnly
            ] = proxy(UpdateFirewallRule, request)
            def getResolverQueryLogConfigPolicy(
                request: GetResolverQueryLogConfigPolicyRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.GetResolverQueryLogConfigPolicyResponse.ReadOnly
            ] = proxy(GetResolverQueryLogConfigPolicy, request)
            def createFirewallDomainList(
                request: CreateFirewallDomainListRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.CreateFirewallDomainListResponse.ReadOnly
            ] = proxy(CreateFirewallDomainList, request)
            def getFirewallConfig(request: GetFirewallConfigRequest): IO[
              AwsError,
              zio.aws.route53resolver.model.GetFirewallConfigResponse.ReadOnly
            ] = proxy(GetFirewallConfig, request)
            def updateResolverDnssecConfig(
                request: UpdateResolverDnssecConfigRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.UpdateResolverDnssecConfigResponse.ReadOnly
            ] = proxy(UpdateResolverDnssecConfig, request)
            def associateResolverRule(
                request: AssociateResolverRuleRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.AssociateResolverRuleResponse.ReadOnly
            ] = proxy(AssociateResolverRule, request)
            def createResolverRule(request: CreateResolverRuleRequest): IO[
              AwsError,
              zio.aws.route53resolver.model.CreateResolverRuleResponse.ReadOnly
            ] = proxy(CreateResolverRule, request)
            def putResolverQueryLogConfigPolicy(
                request: PutResolverQueryLogConfigPolicyRequest
            ): IO[
              AwsError,
              zio.aws.route53resolver.model.PutResolverQueryLogConfigPolicyResponse.ReadOnly
            ] = proxy(PutResolverQueryLogConfigPolicy, request)
            def getFirewallRuleGroup(request: GetFirewallRuleGroupRequest): IO[
              AwsError,
              zio.aws.route53resolver.model.GetFirewallRuleGroupResponse.ReadOnly
            ] = proxy(GetFirewallRuleGroup, request)
          }
        }
      }
    }
  }
}
