package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class DisassociateResolverQueryLogConfigRequest(
    resolverQueryLogConfigId: ResourceId,
    resourceId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.DisassociateResolverQueryLogConfigRequest = {
    import DisassociateResolverQueryLogConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.DisassociateResolverQueryLogConfigRequest
      .builder()
      .resolverQueryLogConfigId(
        ResourceId.unwrap(resolverQueryLogConfigId): java.lang.String
      )
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.DisassociateResolverQueryLogConfigRequest.ReadOnly =
    zio.aws.route53resolver.model.DisassociateResolverQueryLogConfigRequest
      .wrap(buildAwsValue())
}
object DisassociateResolverQueryLogConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.DisassociateResolverQueryLogConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.DisassociateResolverQueryLogConfigRequest =
      zio.aws.route53resolver.model.DisassociateResolverQueryLogConfigRequest(
        resolverQueryLogConfigId,
        resourceId
      )
    def resolverQueryLogConfigId: ResourceId
    def resourceId: ResourceId
    def getResolverQueryLogConfigId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(resolverQueryLogConfigId)
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.DisassociateResolverQueryLogConfigRequest
  ) extends zio.aws.route53resolver.model.DisassociateResolverQueryLogConfigRequest.ReadOnly {
    override val resolverQueryLogConfigId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.resolverQueryLogConfigId())
    override val resourceId: ResourceId =
      zio.aws.route53resolver.model.primitives.ResourceId(impl.resourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.DisassociateResolverQueryLogConfigRequest
  ): zio.aws.route53resolver.model.DisassociateResolverQueryLogConfigRequest.ReadOnly =
    new Wrapper(impl)
}
