package zio.aws.route53resolver.model
import scala.jdk.CollectionConverters._
sealed trait FirewallDomainUpdateOperation {
  def unwrap: software.amazon.awssdk.services.route53resolver.model.FirewallDomainUpdateOperation
}
object FirewallDomainUpdateOperation {
  def wrap(
      value: software.amazon.awssdk.services.route53resolver.model.FirewallDomainUpdateOperation
  ): zio.aws.route53resolver.model.FirewallDomainUpdateOperation = value match {
    case software.amazon.awssdk.services.route53resolver.model.FirewallDomainUpdateOperation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53resolver.model.FirewallDomainUpdateOperation.ADD =>
      val r = ADD
      r
    case software.amazon.awssdk.services.route53resolver.model.FirewallDomainUpdateOperation.REMOVE =>
      val r = REMOVE
      r
    case software.amazon.awssdk.services.route53resolver.model.FirewallDomainUpdateOperation.REPLACE =>
      val r = REPLACE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53resolver.model.FirewallDomainUpdateOperation {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.FirewallDomainUpdateOperation =
      software.amazon.awssdk.services.route53resolver.model.FirewallDomainUpdateOperation.UNKNOWN_TO_SDK_VERSION
  }
  case object ADD
      extends zio.aws.route53resolver.model.FirewallDomainUpdateOperation {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.FirewallDomainUpdateOperation =
      software.amazon.awssdk.services.route53resolver.model.FirewallDomainUpdateOperation.ADD
  }
  case object REMOVE
      extends zio.aws.route53resolver.model.FirewallDomainUpdateOperation {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.FirewallDomainUpdateOperation =
      software.amazon.awssdk.services.route53resolver.model.FirewallDomainUpdateOperation.REMOVE
  }
  case object REPLACE
      extends zio.aws.route53resolver.model.FirewallDomainUpdateOperation {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.FirewallDomainUpdateOperation =
      software.amazon.awssdk.services.route53resolver.model.FirewallDomainUpdateOperation.REPLACE
  }
}
