package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  StatusMessage,
  Name,
  ResourceId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportFirewallDomainsResponse(
    id: Optional[ResourceId] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    status: Optional[zio.aws.route53resolver.model.FirewallDomainListStatus] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ImportFirewallDomainsResponse = {
    import ImportFirewallDomainsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ImportFirewallDomainsResponse
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ImportFirewallDomainsResponse.ReadOnly =
    zio.aws.route53resolver.model.ImportFirewallDomainsResponse
      .wrap(buildAwsValue())
}
object ImportFirewallDomainsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ImportFirewallDomainsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ImportFirewallDomainsResponse =
      zio.aws.route53resolver.model.ImportFirewallDomainsResponse(
        id.map(value => value),
        name.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value)
      )
    def id: Optional[ResourceId]
    def name: Optional[Name]
    def status: Optional[zio.aws.route53resolver.model.FirewallDomainListStatus]
    def statusMessage: Optional[StatusMessage]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallDomainListStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ImportFirewallDomainsResponse
  ) extends zio.aws.route53resolver.model.ImportFirewallDomainsResponse.ReadOnly {
    override val id: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val status
        : Optional[zio.aws.route53resolver.model.FirewallDomainListStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.route53resolver.model.FirewallDomainListStatus.wrap(value)
        )
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value =>
        zio.aws.route53resolver.model.primitives.StatusMessage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ImportFirewallDomainsResponse
  ): zio.aws.route53resolver.model.ImportFirewallDomainsResponse.ReadOnly =
    new Wrapper(impl)
}
