package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateResolverRuleResponse(
    resolverRule: Optional[zio.aws.route53resolver.model.ResolverRule] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.CreateResolverRuleResponse = {
    import CreateResolverRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.CreateResolverRuleResponse
      .builder()
      .optionallyWith(resolverRule.map(value => value.buildAwsValue()))(
        _.resolverRule
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.CreateResolverRuleResponse.ReadOnly =
    zio.aws.route53resolver.model.CreateResolverRuleResponse
      .wrap(buildAwsValue())
}
object CreateResolverRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.CreateResolverRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.CreateResolverRuleResponse =
      zio.aws.route53resolver.model
        .CreateResolverRuleResponse(resolverRule.map(value => value.asEditable))
    def resolverRule
        : Optional[zio.aws.route53resolver.model.ResolverRule.ReadOnly]
    def getResolverRule: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverRule.ReadOnly
    ] = AwsError.unwrapOptionField("resolverRule", resolverRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateResolverRuleResponse
  ) extends zio.aws.route53resolver.model.CreateResolverRuleResponse.ReadOnly {
    override val resolverRule
        : Optional[zio.aws.route53resolver.model.ResolverRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolverRule())
        .map(value => zio.aws.route53resolver.model.ResolverRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateResolverRuleResponse
  ): zio.aws.route53resolver.model.CreateResolverRuleResponse.ReadOnly =
    new Wrapper(impl)
}
