package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{Name, ResourceId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateResolverEndpointRequest(
    resolverEndpointId: ResourceId,
    name: Optional[Name] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointRequest = {
    import UpdateResolverEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointRequest
      .builder()
      .resolverEndpointId(
        ResourceId.unwrap(resolverEndpointId): java.lang.String
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateResolverEndpointRequest.ReadOnly =
    zio.aws.route53resolver.model.UpdateResolverEndpointRequest
      .wrap(buildAwsValue())
}
object UpdateResolverEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.UpdateResolverEndpointRequest =
      zio.aws.route53resolver.model.UpdateResolverEndpointRequest(
        resolverEndpointId,
        name.map(value => value)
      )
    def resolverEndpointId: ResourceId
    def name: Optional[Name]
    def getResolverEndpointId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(resolverEndpointId)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointRequest
  ) extends zio.aws.route53resolver.model.UpdateResolverEndpointRequest.ReadOnly {
    override val resolverEndpointId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.resolverEndpointId())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointRequest
  ): zio.aws.route53resolver.model.UpdateResolverEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
