package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  ResourceId,
  Name,
  CreatorRequestId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateResolverEndpointRequest(
    creatorRequestId: CreatorRequestId,
    name: Optional[Name] = Optional.Absent,
    securityGroupIds: Iterable[ResourceId],
    direction: zio.aws.route53resolver.model.ResolverEndpointDirection,
    ipAddresses: Iterable[zio.aws.route53resolver.model.IpAddressRequest],
    tags: Optional[Iterable[zio.aws.route53resolver.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.CreateResolverEndpointRequest = {
    import CreateResolverEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.CreateResolverEndpointRequest
      .builder()
      .creatorRequestId(
        CreatorRequestId.unwrap(creatorRequestId): java.lang.String
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .securityGroupIds(securityGroupIds.map { item =>
        ResourceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .direction(direction.unwrap)
      .ipAddresses(ipAddresses.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.CreateResolverEndpointRequest.ReadOnly =
    zio.aws.route53resolver.model.CreateResolverEndpointRequest
      .wrap(buildAwsValue())
}
object CreateResolverEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.CreateResolverEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.CreateResolverEndpointRequest =
      zio.aws.route53resolver.model.CreateResolverEndpointRequest(
        creatorRequestId,
        name.map(value => value),
        securityGroupIds,
        direction,
        ipAddresses.map { item =>
          item.asEditable
        },
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def creatorRequestId: CreatorRequestId
    def name: Optional[Name]
    def securityGroupIds: List[ResourceId]
    def direction: zio.aws.route53resolver.model.ResolverEndpointDirection
    def ipAddresses
        : List[zio.aws.route53resolver.model.IpAddressRequest.ReadOnly]
    def tags: Optional[List[zio.aws.route53resolver.model.Tag.ReadOnly]]
    def getCreatorRequestId: ZIO[Any, Nothing, CreatorRequestId] =
      ZIO.succeed(creatorRequestId)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getSecurityGroupIds: ZIO[Any, Nothing, List[ResourceId]] =
      ZIO.succeed(securityGroupIds)
    def getDirection: ZIO[
      Any,
      Nothing,
      zio.aws.route53resolver.model.ResolverEndpointDirection
    ] = ZIO.succeed(direction)
    def getIpAddresses: ZIO[Any, Nothing, List[
      zio.aws.route53resolver.model.IpAddressRequest.ReadOnly
    ]] = ZIO.succeed(ipAddresses)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.route53resolver.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateResolverEndpointRequest
  ) extends zio.aws.route53resolver.model.CreateResolverEndpointRequest.ReadOnly {
    override val creatorRequestId: CreatorRequestId =
      zio.aws.route53resolver.model.primitives
        .CreatorRequestId(impl.creatorRequestId())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val securityGroupIds: List[ResourceId] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.route53resolver.model.primitives.ResourceId(item)
      }
      .toList
    override val direction
        : zio.aws.route53resolver.model.ResolverEndpointDirection =
      zio.aws.route53resolver.model.ResolverEndpointDirection
        .wrap(impl.direction())
    override val ipAddresses
        : List[zio.aws.route53resolver.model.IpAddressRequest.ReadOnly] = impl
      .ipAddresses()
      .asScala
      .map { item =>
        zio.aws.route53resolver.model.IpAddressRequest.wrap(item)
      }
      .toList
    override val tags
        : Optional[List[zio.aws.route53resolver.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53resolver.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateResolverEndpointRequest
  ): zio.aws.route53resolver.model.CreateResolverEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
