package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFirewallRuleGroupAssociationsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    firewallRuleGroupAssociations: Optional[
      Iterable[zio.aws.route53resolver.model.FirewallRuleGroupAssociation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsResponse = {
    import ListFirewallRuleGroupAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        firewallRuleGroupAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.firewallRuleGroupAssociations)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListFirewallRuleGroupAssociationsResponse.ReadOnly =
    zio.aws.route53resolver.model.ListFirewallRuleGroupAssociationsResponse
      .wrap(buildAwsValue())
}
object ListFirewallRuleGroupAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ListFirewallRuleGroupAssociationsResponse =
      zio.aws.route53resolver.model.ListFirewallRuleGroupAssociationsResponse(
        nextToken.map(value => value),
        firewallRuleGroupAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def firewallRuleGroupAssociations: Optional[
      List[zio.aws.route53resolver.model.FirewallRuleGroupAssociation.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFirewallRuleGroupAssociations: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.FirewallRuleGroupAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "firewallRuleGroupAssociations",
      firewallRuleGroupAssociations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsResponse
  ) extends zio.aws.route53resolver.model.ListFirewallRuleGroupAssociationsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val firewallRuleGroupAssociations: Optional[
      List[zio.aws.route53resolver.model.FirewallRuleGroupAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallRuleGroupAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.FirewallRuleGroupAssociation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsResponse
  ): zio.aws.route53resolver.model.ListFirewallRuleGroupAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
