package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{
  SortByKey,
  NextToken,
  MaxResults
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListResolverQueryLogConfigAssociationsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.route53resolver.model.Filter]] =
      Optional.Absent,
    sortBy: Optional[SortByKey] = Optional.Absent,
    sortOrder: Optional[zio.aws.route53resolver.model.SortOrder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest = {
    import ListResolverQueryLogConfigAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        sortBy.map(value => SortByKey.unwrap(value): java.lang.String)
      )(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest.ReadOnly =
    zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest
      .wrap(buildAwsValue())
}
object ListResolverQueryLogConfigAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest =
      zio.aws.route53resolver.model
        .ListResolverQueryLogConfigAssociationsRequest(
          maxResults.map(value => value),
          nextToken.map(value => value),
          filters.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          sortBy.map(value => value),
          sortOrder.map(value => value)
        )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def filters: Optional[List[zio.aws.route53resolver.model.Filter.ReadOnly]]
    def sortBy: Optional[SortByKey]
    def sortOrder: Optional[zio.aws.route53resolver.model.SortOrder]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getSortBy: ZIO[Any, AwsError, SortByKey] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.route53resolver.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest
  ) extends zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.route53resolver.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val filters
        : Optional[List[zio.aws.route53resolver.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53resolver.model.Filter.wrap(item)
          }.toList
        )
    override val sortBy: Optional[SortByKey] = zio.aws.core.internal
      .optionalFromNullable(impl.sortBy())
      .map(value => zio.aws.route53resolver.model.primitives.SortByKey(value))
    override val sortOrder: Optional[zio.aws.route53resolver.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.route53resolver.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest
  ): zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
