package zio.aws.route53resolver.model
import scala.jdk.CollectionConverters._
sealed trait FirewallRuleGroupStatus {
  def unwrap: software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupStatus
}
object FirewallRuleGroupStatus {
  def wrap(
      value: software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupStatus
  ): zio.aws.route53resolver.model.FirewallRuleGroupStatus = value match {
    case software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupStatus.COMPLETE =>
      val r = COMPLETE
      r
    case software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupStatus.UPDATING =>
      val r = UPDATING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53resolver.model.FirewallRuleGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupStatus =
      software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLETE
      extends zio.aws.route53resolver.model.FirewallRuleGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupStatus =
      software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupStatus.COMPLETE
  }
  case object DELETING
      extends zio.aws.route53resolver.model.FirewallRuleGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupStatus =
      software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupStatus.DELETING
  }
  case object UPDATING
      extends zio.aws.route53resolver.model.FirewallRuleGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupStatus =
      software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupStatus.UPDATING
  }
}
