package zio.aws.route53resolver.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{MaxResults, NextToken}
import scala.jdk.CollectionConverters._
final case class ListResolverRuleAssociationsResponse(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    resolverRuleAssociations: Option[
      Iterable[zio.aws.route53resolver.model.ResolverRuleAssociation]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse = {
    import ListResolverRuleAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        resolverRuleAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resolverRuleAssociations)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse.ReadOnly =
    zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse
      .wrap(buildAwsValue())
}
object ListResolverRuleAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse =
      zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse(
        nextToken.map(value => value),
        maxResults.map(value => value),
        resolverRuleAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def resolverRuleAssociations: Option[
      List[zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getResolverRuleAssociations: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resolverRuleAssociations",
      resolverRuleAssociations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse
  ) extends zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.route53resolver.model.primitives.MaxResults(value))
    override val resolverRuleAssociations: Option[
      List[zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly]
    ] = scala
      .Option(impl.resolverRuleAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.ResolverRuleAssociation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse
  ): zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
