package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class GetFirewallRuleGroupPolicyRequest(arn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupPolicyRequest = {
    import GetFirewallRuleGroupPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupPolicyRequest
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetFirewallRuleGroupPolicyRequest.ReadOnly =
    zio.aws.route53resolver.model.GetFirewallRuleGroupPolicyRequest
      .wrap(buildAwsValue())
}
object GetFirewallRuleGroupPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.GetFirewallRuleGroupPolicyRequest =
      zio.aws.route53resolver.model.GetFirewallRuleGroupPolicyRequest(arn)
    def arn: Arn
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupPolicyRequest
  ) extends zio.aws.route53resolver.model.GetFirewallRuleGroupPolicyRequest.ReadOnly {
    override val arn: Arn =
      zio.aws.route53resolver.model.primitives.Arn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupPolicyRequest
  ): zio.aws.route53resolver.model.GetFirewallRuleGroupPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
