package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFirewallDomainListResponse(
    firewallDomainList: Option[
      zio.aws.route53resolver.model.FirewallDomainList
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.CreateFirewallDomainListResponse = {
    import CreateFirewallDomainListResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.CreateFirewallDomainListResponse
      .builder()
      .optionallyWith(firewallDomainList.map(value => value.buildAwsValue()))(
        _.firewallDomainList
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.CreateFirewallDomainListResponse.ReadOnly =
    zio.aws.route53resolver.model.CreateFirewallDomainListResponse
      .wrap(buildAwsValue())
}
object CreateFirewallDomainListResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.CreateFirewallDomainListResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.CreateFirewallDomainListResponse =
      zio.aws.route53resolver.model.CreateFirewallDomainListResponse(
        firewallDomainList.map(value => value.asEditable)
      )
    def firewallDomainList
        : Option[zio.aws.route53resolver.model.FirewallDomainList.ReadOnly]
    def getFirewallDomainList: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallDomainList.ReadOnly
    ] = AwsError.unwrapOptionField("firewallDomainList", firewallDomainList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateFirewallDomainListResponse
  ) extends zio.aws.route53resolver.model.CreateFirewallDomainListResponse.ReadOnly {
    override val firewallDomainList
        : Option[zio.aws.route53resolver.model.FirewallDomainList.ReadOnly] =
      scala
        .Option(impl.firewallDomainList())
        .map(value =>
          zio.aws.route53resolver.model.FirewallDomainList.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateFirewallDomainListResponse
  ): zio.aws.route53resolver.model.CreateFirewallDomainListResponse.ReadOnly =
    new Wrapper(impl)
}
