package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateFirewallConfigResponse(
    firewallConfig: Option[zio.aws.route53resolver.model.FirewallConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateFirewallConfigResponse = {
    import UpdateFirewallConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateFirewallConfigResponse
      .builder()
      .optionallyWith(firewallConfig.map(value => value.buildAwsValue()))(
        _.firewallConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateFirewallConfigResponse.ReadOnly =
    zio.aws.route53resolver.model.UpdateFirewallConfigResponse
      .wrap(buildAwsValue())
}
object UpdateFirewallConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateFirewallConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.UpdateFirewallConfigResponse =
      zio.aws.route53resolver.model.UpdateFirewallConfigResponse(
        firewallConfig.map(value => value.asEditable)
      )
    def firewallConfig
        : Option[zio.aws.route53resolver.model.FirewallConfig.ReadOnly]
    def getFirewallConfig: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallConfig.ReadOnly
    ] = AwsError.unwrapOptionField("firewallConfig", firewallConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateFirewallConfigResponse
  ) extends zio.aws.route53resolver.model.UpdateFirewallConfigResponse.ReadOnly {
    override val firewallConfig
        : Option[zio.aws.route53resolver.model.FirewallConfig.ReadOnly] = scala
      .Option(impl.firewallConfig())
      .map(value => zio.aws.route53resolver.model.FirewallConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateFirewallConfigResponse
  ): zio.aws.route53resolver.model.UpdateFirewallConfigResponse.ReadOnly =
    new Wrapper(impl)
}
