package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteResolverEndpointResponse(
    resolverEndpoint: Option[zio.aws.route53resolver.model.ResolverEndpoint] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.DeleteResolverEndpointResponse = {
    import DeleteResolverEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.DeleteResolverEndpointResponse
      .builder()
      .optionallyWith(resolverEndpoint.map(value => value.buildAwsValue()))(
        _.resolverEndpoint
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.DeleteResolverEndpointResponse.ReadOnly =
    zio.aws.route53resolver.model.DeleteResolverEndpointResponse
      .wrap(buildAwsValue())
}
object DeleteResolverEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.DeleteResolverEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.DeleteResolverEndpointResponse =
      zio.aws.route53resolver.model.DeleteResolverEndpointResponse(
        resolverEndpoint.map(value => value.asEditable)
      )
    def resolverEndpoint
        : Option[zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly]
    def getResolverEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("resolverEndpoint", resolverEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteResolverEndpointResponse
  ) extends zio.aws.route53resolver.model.DeleteResolverEndpointResponse.ReadOnly {
    override val resolverEndpoint
        : Option[zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly] =
      scala
        .Option(impl.resolverEndpoint())
        .map(value =>
          zio.aws.route53resolver.model.ResolverEndpoint.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteResolverEndpointResponse
  ): zio.aws.route53resolver.model.DeleteResolverEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
