package zio.aws.route53resolver.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{MaxResults, NextToken}
import scala.jdk.CollectionConverters._
final case class ListResolverRulesResponse(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    resolverRules: Option[
      Iterable[zio.aws.route53resolver.model.ResolverRule]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse = {
    import ListResolverRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        resolverRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resolverRules)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverRulesResponse.ReadOnly =
    zio.aws.route53resolver.model.ListResolverRulesResponse
      .wrap(buildAwsValue())
}
object ListResolverRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ListResolverRulesResponse =
      zio.aws.route53resolver.model.ListResolverRulesResponse(
        nextToken.map(value => value),
        maxResults.map(value => value),
        resolverRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def resolverRules
        : Option[List[zio.aws.route53resolver.model.ResolverRule.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getResolverRules: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.ResolverRule.ReadOnly
    ]] = AwsError.unwrapOptionField("resolverRules", resolverRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse
  ) extends zio.aws.route53resolver.model.ListResolverRulesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.route53resolver.model.primitives.MaxResults(value))
    override val resolverRules
        : Option[List[zio.aws.route53resolver.model.ResolverRule.ReadOnly]] =
      scala
        .Option(impl.resolverRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53resolver.model.ResolverRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse
  ): zio.aws.route53resolver.model.ListResolverRulesResponse.ReadOnly =
    new Wrapper(impl)
}
