package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListFirewallRuleGroupsResponse(
    nextToken: Option[NextToken] = None,
    firewallRuleGroups: Option[
      Iterable[zio.aws.route53resolver.model.FirewallRuleGroupMetadata]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsResponse = {
    import ListFirewallRuleGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        firewallRuleGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.firewallRuleGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListFirewallRuleGroupsResponse.ReadOnly =
    zio.aws.route53resolver.model.ListFirewallRuleGroupsResponse
      .wrap(buildAwsValue())
}
object ListFirewallRuleGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ListFirewallRuleGroupsResponse =
      zio.aws.route53resolver.model.ListFirewallRuleGroupsResponse(
        nextToken.map(value => value),
        firewallRuleGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def firewallRuleGroups: Option[
      List[zio.aws.route53resolver.model.FirewallRuleGroupMetadata.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFirewallRuleGroups: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.FirewallRuleGroupMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("firewallRuleGroups", firewallRuleGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsResponse
  ) extends zio.aws.route53resolver.model.ListFirewallRuleGroupsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val firewallRuleGroups: Option[
      List[zio.aws.route53resolver.model.FirewallRuleGroupMetadata.ReadOnly]
    ] = scala
      .Option(impl.firewallRuleGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.FirewallRuleGroupMetadata.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsResponse
  ): zio.aws.route53resolver.model.ListFirewallRuleGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
