package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateFirewallRuleResponse(
    firewallRule: Option[zio.aws.route53resolver.model.FirewallRule] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleResponse = {
    import UpdateFirewallRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleResponse
      .builder()
      .optionallyWith(firewallRule.map(value => value.buildAwsValue()))(
        _.firewallRule
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateFirewallRuleResponse.ReadOnly =
    zio.aws.route53resolver.model.UpdateFirewallRuleResponse
      .wrap(buildAwsValue())
}
object UpdateFirewallRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.UpdateFirewallRuleResponse =
      zio.aws.route53resolver.model
        .UpdateFirewallRuleResponse(firewallRule.map(value => value.asEditable))
    def firewallRule
        : Option[zio.aws.route53resolver.model.FirewallRule.ReadOnly]
    def getFirewallRule: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallRule.ReadOnly
    ] = AwsError.unwrapOptionField("firewallRule", firewallRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleResponse
  ) extends zio.aws.route53resolver.model.UpdateFirewallRuleResponse.ReadOnly {
    override val firewallRule
        : Option[zio.aws.route53resolver.model.FirewallRule.ReadOnly] = scala
      .Option(impl.firewallRule())
      .map(value => zio.aws.route53resolver.model.FirewallRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleResponse
  ): zio.aws.route53resolver.model.UpdateFirewallRuleResponse.ReadOnly =
    new Wrapper(impl)
}
