package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListResolverDnssecConfigsResponse(
    nextToken: Option[NextToken] = None,
    resolverDnssecConfigs: Option[
      Iterable[zio.aws.route53resolver.model.ResolverDnssecConfig]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsResponse = {
    import ListResolverDnssecConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        resolverDnssecConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resolverDnssecConfigs)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverDnssecConfigsResponse.ReadOnly =
    zio.aws.route53resolver.model.ListResolverDnssecConfigsResponse
      .wrap(buildAwsValue())
}
object ListResolverDnssecConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ListResolverDnssecConfigsResponse =
      zio.aws.route53resolver.model.ListResolverDnssecConfigsResponse(
        nextToken.map(value => value),
        resolverDnssecConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def resolverDnssecConfigs: Option[
      List[zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResolverDnssecConfigs: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resolverDnssecConfigs", resolverDnssecConfigs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsResponse
  ) extends zio.aws.route53resolver.model.ListResolverDnssecConfigsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val resolverDnssecConfigs: Option[
      List[zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly]
    ] = scala
      .Option(impl.resolverDnssecConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.ResolverDnssecConfig.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsResponse
  ): zio.aws.route53resolver.model.ListResolverDnssecConfigsResponse.ReadOnly =
    new Wrapper(impl)
}
