package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.ResolverQueryLogConfigPolicy
import scala.jdk.CollectionConverters._
final case class GetResolverQueryLogConfigPolicyResponse(
    resolverQueryLogConfigPolicy: Option[ResolverQueryLogConfigPolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigPolicyResponse = {
    import GetResolverQueryLogConfigPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigPolicyResponse
      .builder()
      .optionallyWith(
        resolverQueryLogConfigPolicy.map(value =>
          ResolverQueryLogConfigPolicy.unwrap(value): java.lang.String
        )
      )(_.resolverQueryLogConfigPolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetResolverQueryLogConfigPolicyResponse.ReadOnly =
    zio.aws.route53resolver.model.GetResolverQueryLogConfigPolicyResponse
      .wrap(buildAwsValue())
}
object GetResolverQueryLogConfigPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.GetResolverQueryLogConfigPolicyResponse =
      zio.aws.route53resolver.model.GetResolverQueryLogConfigPolicyResponse(
        resolverQueryLogConfigPolicy.map(value => value)
      )
    def resolverQueryLogConfigPolicy: Option[ResolverQueryLogConfigPolicy]
    def getResolverQueryLogConfigPolicy
        : ZIO[Any, AwsError, ResolverQueryLogConfigPolicy] =
      AwsError.unwrapOptionField(
        "resolverQueryLogConfigPolicy",
        resolverQueryLogConfigPolicy
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigPolicyResponse
  ) extends zio.aws.route53resolver.model.GetResolverQueryLogConfigPolicyResponse.ReadOnly {
    override val resolverQueryLogConfigPolicy
        : Option[ResolverQueryLogConfigPolicy] = scala
      .Option(impl.resolverQueryLogConfigPolicy())
      .map(value =>
        zio.aws.route53resolver.model.primitives
          .ResolverQueryLogConfigPolicy(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigPolicyResponse
  ): zio.aws.route53resolver.model.GetResolverQueryLogConfigPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
