package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class GetFirewallConfigRequest(resourceId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetFirewallConfigRequest = {
    import GetFirewallConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetFirewallConfigRequest
      .builder()
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetFirewallConfigRequest.ReadOnly =
    zio.aws.route53resolver.model.GetFirewallConfigRequest.wrap(buildAwsValue())
}
object GetFirewallConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetFirewallConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.GetFirewallConfigRequest =
      zio.aws.route53resolver.model.GetFirewallConfigRequest(resourceId)
    def resourceId: ResourceId
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetFirewallConfigRequest
  ) extends zio.aws.route53resolver.model.GetFirewallConfigRequest.ReadOnly {
    override val resourceId: ResourceId =
      zio.aws.route53resolver.model.primitives.ResourceId(impl.resourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetFirewallConfigRequest
  ): zio.aws.route53resolver.model.GetFirewallConfigRequest.ReadOnly =
    new Wrapper(impl)
}
