package zio.aws.route53resolver.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  CreatorRequestId,
  Unsigned,
  AccountId,
  Arn,
  Rfc3339TimeString,
  Name,
  ResourceId,
  StatusMessage
}
import scala.jdk.CollectionConverters._
final case class FirewallRuleGroup(
    id: Option[ResourceId] = None,
    arn: Option[Arn] = None,
    name: Option[Name] = None,
    ruleCount: Option[Unsigned] = None,
    status: Option[zio.aws.route53resolver.model.FirewallRuleGroupStatus] =
      None,
    statusMessage: Option[StatusMessage] = None,
    ownerId: Option[AccountId] = None,
    creatorRequestId: Option[CreatorRequestId] = None,
    shareStatus: Option[zio.aws.route53resolver.model.ShareStatus] = None,
    creationTime: Option[Rfc3339TimeString] = None,
    modificationTime: Option[Rfc3339TimeString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroup = {
    import FirewallRuleGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroup
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(ruleCount.map(value => Unsigned.unwrap(value): Integer))(
        _.ruleCount
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        ownerId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        creatorRequestId.map(value =>
          CreatorRequestId.unwrap(value): java.lang.String
        )
      )(_.creatorRequestId)
      .optionallyWith(shareStatus.map(value => value.unwrap))(_.shareStatus)
      .optionallyWith(
        creationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.creationTime)
      .optionallyWith(
        modificationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.modificationTime)
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.FirewallRuleGroup.ReadOnly =
    zio.aws.route53resolver.model.FirewallRuleGroup.wrap(buildAwsValue())
}
object FirewallRuleGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.FirewallRuleGroup =
      zio.aws.route53resolver.model.FirewallRuleGroup(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        ruleCount.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        ownerId.map(value => value),
        creatorRequestId.map(value => value),
        shareStatus.map(value => value),
        creationTime.map(value => value),
        modificationTime.map(value => value)
      )
    def id: Option[ResourceId]
    def arn: Option[Arn]
    def name: Option[Name]
    def ruleCount: Option[Unsigned]
    def status: Option[zio.aws.route53resolver.model.FirewallRuleGroupStatus]
    def statusMessage: Option[StatusMessage]
    def ownerId: Option[AccountId]
    def creatorRequestId: Option[CreatorRequestId]
    def shareStatus: Option[zio.aws.route53resolver.model.ShareStatus]
    def creationTime: Option[Rfc3339TimeString]
    def modificationTime: Option[Rfc3339TimeString]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getRuleCount: ZIO[Any, AwsError, Unsigned] =
      AwsError.unwrapOptionField("ruleCount", ruleCount)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallRuleGroupStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getOwnerId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getCreatorRequestId: ZIO[Any, AwsError, CreatorRequestId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getShareStatus
        : ZIO[Any, AwsError, zio.aws.route53resolver.model.ShareStatus] =
      AwsError.unwrapOptionField("shareStatus", shareStatus)
    def getCreationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getModificationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("modificationTime", modificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroup
  ) extends zio.aws.route53resolver.model.FirewallRuleGroup.ReadOnly {
    override val id: Option[ResourceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.route53resolver.model.primitives.Arn(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val ruleCount: Option[Unsigned] = scala
      .Option(impl.ruleCount())
      .map(value => zio.aws.route53resolver.model.primitives.Unsigned(value))
    override val status
        : Option[zio.aws.route53resolver.model.FirewallRuleGroupStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.route53resolver.model.FirewallRuleGroupStatus.wrap(value)
      )
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.route53resolver.model.primitives.StatusMessage(value)
      )
    override val ownerId: Option[AccountId] = scala
      .Option(impl.ownerId())
      .map(value => zio.aws.route53resolver.model.primitives.AccountId(value))
    override val creatorRequestId: Option[CreatorRequestId] = scala
      .Option(impl.creatorRequestId())
      .map(value =>
        zio.aws.route53resolver.model.primitives.CreatorRequestId(value)
      )
    override val shareStatus
        : Option[zio.aws.route53resolver.model.ShareStatus] = scala
      .Option(impl.shareStatus())
      .map(value => zio.aws.route53resolver.model.ShareStatus.wrap(value))
    override val creationTime: Option[Rfc3339TimeString] = scala
      .Option(impl.creationTime())
      .map(value =>
        zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
      )
    override val modificationTime: Option[Rfc3339TimeString] = scala
      .Option(impl.modificationTime())
      .map(value =>
        zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroup
  ): zio.aws.route53resolver.model.FirewallRuleGroup.ReadOnly = new Wrapper(
    impl
  )
}
